/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.bulkio;

import java.util.AbstractQueue;
import java.util.Iterator;

public class ThreadSafeLazyIteratorQueue<T>
extends AbstractQueue<T> {
    private final Iterator<T> iterator;
    private T nextElement;
    private boolean nextElementFetched = false;
    private final Object lock = new Object();

    public ThreadSafeLazyIteratorQueue(Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator cannot be null");
        }
        this.iterator = iterator;
    }

    private void ensureNext() {
        if (!this.nextElementFetched && this.iterator.hasNext()) {
            this.nextElement = this.iterator.next();
            this.nextElementFetched = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        Object object = this.lock;
        synchronized (object) {
            this.ensureNext();
            return this.nextElementFetched ? (T)this.nextElement : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        Object object = this.lock;
        synchronized (object) {
            this.ensureNext();
            if (!this.nextElementFetched) {
                return null;
            }
            T result = this.nextElement;
            this.nextElement = null;
            this.nextElementFetched = false;
            return result;
        }
    }

    @Override
    public boolean offer(T t) {
        throw new UnsupportedOperationException("offer() is not supported in ThreadSafeLazyIteratorQueue");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Iterator access is not supported for ThreadSafeLazyIteratorQueue");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size() is not supported for ThreadSafeLazyIteratorQueue");
    }
}

