/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.evaluator;

import io.nosqlbench.nbvectors.jjq.apis.NBJJQ;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContext;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContextHolderHack;
import io.nosqlbench.nbvectors.jjq.evaluator.JqProc;
import io.nosqlbench.nbvectors.jjq.evaluator.JsonNodeMapper;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.module.loaders.BuiltinModuleLoader;
import net.thisptr.jackson.jq.module.loaders.ChainedModuleLoader;
import net.thisptr.jackson.jq.module.loaders.FileSystemModuleLoader;

public class JJQInvoker
implements Runnable,
AutoCloseable {
    private final String expr;
    private final Output output;
    private final Supplier<String> lines;
    private Scope rootScope;
    private NBStateContextHolderHack nbContext;

    public JJQInvoker(Supplier<String> lines, String expr, Output output) {
        this.lines = lines;
        this.expr = expr;
        this.output = output;
    }

    @Override
    public void run() {
        try {
            this.nbContext = new NBStateContextHolderHack();
            this.rootScope = this.rootScope(this.nbContext);
            JsonNodeMapper mapper = new JsonNodeMapper();
            JsonQuery query = JsonQuery.compile((String)this.expr, (Version)Versions.JQ_1_6);
            Scope scope = Scope.newChildScope((Scope)this.rootScope);
            JqProc f = new JqProc("diagnostic evaluation", scope, this.lines, mapper, query, this.output);
            f.run();
            System.out.println("NbState:");
            NBJJQ.getState(this.rootScope).forEach((k, v) -> System.out.println(" k:" + k + ", v:" + String.valueOf(v)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Scope getScope() {
        return this.rootScope;
    }

    public NBStateContext getContext() {
        return this.nbContext;
    }

    private Scope rootScope(NBStateContextHolderHack context) {
        try {
            Scope scope = Scope.newEmptyScope();
            BuiltinFunctionLoader.getInstance().loadFunctions(Version.LATEST, scope);
            scope.setModuleLoader((ModuleLoader)new ChainedModuleLoader(new ModuleLoader[]{BuiltinModuleLoader.getInstance(), new FileSystemModuleLoader(scope, Version.LATEST, new Path[]{FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath()})}));
            scope.addFunction("nbstate", (Function)context);
            return scope;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.nbContext.close();
    }
}

