/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.evaluator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Output;
import net.thisptr.jackson.jq.Scope;

public class JqProc
implements Runnable {
    private final Scope scope;
    private final Supplier<String> jsonlSource;
    private final Function<String, JsonNode> mapper;
    private final JsonQuery query;
    private final Output output;
    private final String id;

    public JqProc(String id, Scope scope, Supplier<String> jsonlSource, Function<String, JsonNode> mapper, JsonQuery query, Output output) {
        this.id = id;
        this.scope = scope;
        this.jsonlSource = jsonlSource;
        this.mapper = mapper;
        this.query = query;
        this.output = output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            int count = 0;
            String inputJson = null;
            while ((inputJson = this.jsonlSource.get()) != null) {
                JsonNode node;
                ++count;
                try {
                    node = this.mapper.apply(inputJson);
                }
                catch (Exception e) {
                    throw new RuntimeException("error parsing input:\n>>" + inputJson + "\n>>\n");
                }
                try {
                    this.query.apply(this.scope, node, this.output);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

