/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.nbfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.service.AutoService;
import io.nosqlbench.nbvectors.jjq.apis.NBBaseJQFunction;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContext;
import io.nosqlbench.nbvectors.jjq.contexts.NBEnumContext;
import io.nosqlbench.nbvectors.jjq.contexts.NBIdEnumerator;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"nbenum/1"})
@AutoService(value={Function.class})
public class nbenum
extends NBBaseJQFunction {
    private NBIdEnumerator enumer;
    private String dirpath;
    private String fieldName;

    @Override
    public void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        if (in.isNull() || in.isEmpty()) {
            return;
        }
        if (in.has(this.fieldName)) {
            System.err.println("object already contains enumerated field '" + this.fieldName + "', all fields:");
            in.fieldNames().forEachRemaining(System.err::println);
        }
        long value = this.enumer.getAsLong();
        JsonNode out = in;
        if (!(out instanceof ObjectNode)) {
            throw new RuntimeException("Unable to modify node of type '" + out.getClass().getCanonicalName());
        }
        ObjectNode onode = (ObjectNode)out;
        onode.set(this.fieldName, (JsonNode)new LongNode(value));
        output.emit(out, path);
    }

    @Override
    public void start(Scope scope, List<Expression> args, JsonNode in, NBStateContext nbctx) throws JsonQueryException {
        args.getFirst().apply(scope, in, fieldname -> {
            System.out.println("enumerating fieldname:" + String.valueOf(fieldname));
            this.fieldName = fieldname.asText();
        });
        Map<String, Object> state = this.getState();
        this.enumer = (NBIdEnumerator)state.computeIfAbsent("enumerator_context", k -> new NBEnumContext(this.fieldName));
    }
}

