/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.nbfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.service.AutoService;
import io.nosqlbench.nbvectors.jjq.apis.NBBaseJQFunction;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContext;
import io.nosqlbench.nbvectors.jjq.contexts.NBHistogramContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"nbhisto/1"})
@AutoService(value={Function.class})
public class nbhisto
extends NBBaseJQFunction {
    private ConcurrentHashMap<String, AtomicLong> counts;
    private AtomicLong counter;

    @Override
    public void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        if (in.isNull()) {
            return;
        }
        args.get(0).apply(scope, in, n -> {
            String text = n.asText();
            AtomicLong along = this.counts.computeIfAbsent(text, t -> new AtomicLong());
            along.incrementAndGet();
        });
        output.emit(in, path);
    }

    @Override
    public void start(Scope scope, List<Expression> args, JsonNode in, NBStateContext nbctx) {
        Map<String, Object> state = this.getState();
        this.counts = (ConcurrentHashMap)state.computeIfAbsent("nbhistogram_counts", k -> new NBHistogramContext().registerShutdownHook(nbctx));
    }

    @Override
    public void shutdown() {
        System.out.println(this.counts);
    }
}

