/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.nbfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.service.AutoService;
import io.nosqlbench.nbvectors.jjq.apis.NBBaseJQFunction;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContext;
import io.nosqlbench.nbvectors.jjq.contexts.NBIdMapper;
import io.nosqlbench.nbvectors.jjq.contexts.NBTriesContext;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"nbindex/2"})
@AutoService(value={Function.class})
public class nbindex
extends NBBaseJQFunction {
    private NBIdMapper mapper;
    private String filepath;
    private String fieldName;

    @Override
    public void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        if (in.isNull() || in.isEmpty()) {
            return;
        }
        if (in.has(this.fieldName)) {
            JsonNode node = in.get(this.fieldName);
            this.mapper.addInstance(this.fieldName, node.asText());
        }
        output.emit(in, path);
    }

    @Override
    public void start(Scope scope, List<Expression> args, JsonNode in, NBStateContext nbctx) throws JsonQueryException {
        args.get(1).apply(scope, in, path -> {
            Preconditions.checkArgumentType((String)"nbindex/2", (int)1, (JsonNode)path, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
            ((Expression)args.get(0)).apply(scope, in, expr -> {
                Preconditions.checkArgumentType((String)"nbindex/2", (int)2, (JsonNode)path, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
                this.fieldName = expr.asText();
            });
        });
        Expression fileExpr = args.get(1);
        fileExpr.apply(scope, in, n -> {
            if (!n.isTextual()) {
                throw new RuntimeException("file expr must yield a string");
            }
            this.filepath = n.asText();
        });
        Map<String, Object> state = this.getState();
        this.mapper = (NBIdMapper)state.computeIfAbsent("mapper_context", k -> new NBTriesContext(this.filepath).registerShutdownHook(nbctx));
    }
}

