/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.jjq.nbfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.google.auto.service.AutoService;
import io.nosqlbench.nbvectors.jjq.apis.NBBaseJQFunction;
import io.nosqlbench.nbvectors.jjq.apis.NBStateContext;
import io.nosqlbench.nbvectors.jjq.contexts.NBIdMapper;
import io.nosqlbench.nbvectors.jjq.contexts.NBTriesContext;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"nbremap/2"})
@AutoService(value={Function.class})
public class nbremap
extends NBBaseJQFunction {
    private NBIdMapper mapper;
    private String file;
    private String dirpath;
    private String fieldName;

    @Override
    public void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        if (in.isNull()) {
            return;
        }
        if (!in.isTextual()) {
            throw new RuntimeException("field value must be textual, but it is " + in.toPrettyString());
        }
        long value = this.mapper.lookupId(this.fieldName, in.asText());
        LongNode out = LongNode.valueOf((long)value);
        output.emit((JsonNode)out, path);
    }

    @Override
    public void start(Scope scope, List<Expression> args, JsonNode in, NBStateContext nbctx) throws JsonQueryException {
        args.get(1).apply(scope, in, path -> {
            Preconditions.checkArgumentType((String)"nbindex/2", (int)1, (JsonNode)path, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
            ((Expression)args.get(0)).apply(scope, in, fieldname -> {
                System.out.println("path:" + String.valueOf(path) + ", fieldname:" + String.valueOf(fieldname));
                this.fieldName = fieldname.asText();
            });
        });
        Expression fileExpr = args.get(1);
        fileExpr.apply(scope, in, n -> {
            if (!n.isTextual()) {
                throw new RuntimeException("file expr must yield a string");
            }
            this.dirpath = n.asText();
        });
        Map<String, Object> state = this.getState();
        this.mapper = (NBIdMapper)state.computeIfAbsent("mapper_context", k -> new NBTriesContext(this.dirpath));
    }
}

