/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.showhdf5;

import io.jhdf.HdfFile;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.nosqlbench.nbvectors.buildhdf5.predicates.types.PNode;
import io.nosqlbench.nbvectors.showhdf5.DatasetNames;
import io.nosqlbench.nbvectors.verifyknn.logging.CustomConfigurationFactory;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="showhdf5", headerHeading="Usage:%n%n", synopsisHeading="%n", descriptionHeading="%nDescription%n%n", parameterListHeading="%nParameters:%n%", optionListHeading="%nOptions:%n", header={"Show details of HDF5 KNN answer-keys"}, description={"TBD\n"}, exitCodeListHeading="Exit Codes:%n", exitCodeList={"0: no errors"})
public class CMD_ShowHDF5
implements Callable<Integer> {
    private static final Logger logger = LogManager.getLogger(CMD_ShowHDF5.class);
    @CommandLine.Parameters(description={"The HDF5 file to view"})
    private Path file;
    @CommandLine.Option(names={"--datasets", "-d"}, description={"Valid values: ${COMPLETION-CANDIDATES}"})
    private List<DatasetNames> decode;

    public static void main(String[] args) {
        System.setProperty("slf4j.internal.verbosity", "ERROR");
        System.setProperty("log4j.configurationFactory", CustomConfigurationFactory.class.getCanonicalName());
        CMD_ShowHDF5 command = new CMD_ShowHDF5();
        logger.info("instancing commandline");
        CommandLine commandLine = new CommandLine((Object)command).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true);
        logger.info("executing commandline");
        int exitCode = commandLine.execute(args);
        logger.info("exiting main");
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        StringBuilder sb = new StringBuilder();
        try (HdfFile file = new HdfFile(this.file);){
            if (this.decode == null || this.decode.isEmpty()) {
                this.walkHdf((Node)file, sb, 0);
            } else {
                block8: for (DatasetNames dsname : this.decode) {
                    switch (dsname) {
                        case filters: {
                            this.decodeFilters(sb, file.getDatasetByPath(DatasetNames.filters.name()));
                            continue block8;
                        }
                    }
                    throw new RuntimeException("unable to show decoded dataset " + dsname.name());
                }
            }
        }
        System.out.println(sb);
        return 0;
    }

    private void decodeFilters(StringBuilder sb, Dataset ds) {
        System.out.println("# predicates from filters dataset:");
        int[] dimensions = ds.getDimensions();
        for (int i = 0; i < dimensions[0]; ++i) {
            Object datao = ds.getData(new long[]{i, 0L}, new int[]{1, dimensions[1]});
            byte[][] data = (byte[][])datao;
            byte[] datum = data[0];
            PNode<?> node = PNode.fromBuffer(ByteBuffer.wrap(datum));
            System.out.printf("predicate[%d]: %s%n", i, node);
        }
    }

    private void walkHdf(Node node, StringBuilder sb, int level) {
        sb.append(" ".repeat(level)).append(node.getName()).append(" (").append(node.getClass().getSimpleName()).append(")\n");
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Dataset.class, Group.class}, (Node)node3, n)) {
            case 0: {
                Dataset dataset = (Dataset)node3;
                this.describeDataset(dataset, sb, level + 1);
                break;
            }
            case 1: {
                Group group = (Group)node3;
                this.describeGroup(group, sb, level);
                for (Node childNode : group.getChildren().values()) {
                    this.walkHdf(childNode, sb, level + 1);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown type to represent: " + node.getClass().getCanonicalName());
            }
        }
    }

    private void describeGroup(Group group, StringBuilder sb, int level) {
    }

    private void describeDataset(Dataset dataset, StringBuilder sb, int level) {
        sb.append(" ".repeat(level));
        sb.append("dimensions: ");
        sb.append(Arrays.toString(dataset.getDimensions()));
        sb.append("\n");
        sb.append(" ".repeat(level));
        sb.append("layout: ");
        sb.append(dataset.getDataLayout());
        sb.append("\n");
        sb.append(" ".repeat(level));
        sb.append("java type: ");
        sb.append(dataset.getJavaType().getCanonicalName());
        sb.append("\n");
        sb.append(" ".repeat(level));
        sb.append("data class: ");
        sb.append(dataset.getDataType().getDataClass());
        sb.append("\n");
        sb.append(" ".repeat(level));
        sb.append("data size: ");
        sb.append(dataset.getDataType().getSize());
        sb.append("\n");
        sb.append(" ".repeat(level));
        sb.append("data version: ");
        sb.append(dataset.getDataType().getVersion());
        sb.append("\n");
    }
}

