/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf;

import io.jhdf.HdfFile;
import io.jhdf.WritableHdfFile;
import io.jhdf.api.Node;
import io.nosqlbench.nbvectors.taghdf.attrtypes.AttrSet;
import io.nosqlbench.nbvectors.taghdf.attrtypes.AttrSetConverter;
import io.nosqlbench.nbvectors.taghdf.traversal.HdfTraverser;
import io.nosqlbench.nbvectors.taghdf.traversal.filters.BaseHdfVisitorFilter;
import io.nosqlbench.nbvectors.taghdf.traversal.injectors.BaseHdfVisitorInjector;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.HdfCompoundVisitor;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.HdfPrintVisitor;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.HdfWriterVisitor;
import io.nosqlbench.nbvectors.taghdf.traversalv2.NullTransformer;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="taghdf", description={"read or write hdf attributes"})
public class CMD_TagHDF5
implements Callable<Integer> {
    private final HdfTraverser hdfTraverser = new HdfTraverser(new BaseHdfVisitorFilter(), new BaseHdfVisitorInjector());
    @CommandLine.Option(names={"-i", "--in", "--hdf_source"}, required=true, description={"The HDF5 file to modify"})
    private Path hdfSource;
    @CommandLine.Option(names={"-o", "--out", "--hdf_target"}, description={"The HDF5 file to modify"})
    private Path hdfTarget;
    @CommandLine.Option(names={"-s", "--set", "--set-attribute"}, description={"The HDF5 attribute to set"}, converter={AttrSetConverter.class})
    private AttrSet[] attrs;

    public static void main(String[] args) {
        CMD_TagHDF5 command = new CMD_TagHDF5();
        CommandLine commandLine = new CommandLine((Object)command).setCaseInsensitiveEnumValuesAllowed(true).setOptionsCaseInsensitive(true);
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        HdfFile in = new HdfFile(this.hdfSource);
        this.hdfTarget = this.hdfTarget == null ? Path.of("_out.hdf5", new String[0]) : this.hdfTarget;
        WritableHdfFile out = HdfFile.write((Path)this.hdfTarget);
        NullTransformer transformer = new NullTransformer();
        HdfTraverser hdfTraverser = new HdfTraverser();
        HdfCompoundVisitor traversers = new HdfCompoundVisitor();
        traversers.add(new HdfPrintVisitor());
        traversers.add(new HdfWriterVisitor(out));
        hdfTraverser.traverse((Node)in, traversers);
        return 0;
    }
}

