/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.attrtypes;

import io.nosqlbench.nbvectors.taghdf.attrtypes.AttrSpec;
import io.nosqlbench.nbvectors.taghdf.attrtypes.AttrValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record AttrSet(AttrSpec attrname, AttrValue<?> attrvalue) {
    private static final Pattern SPEC_PATTERN = Pattern.compile("(?<attrname>" + AttrSpec.SPEC_PATTERN.pattern() + ") *= *(?<attrvalue>" + AttrValue.SPEC_PATTERN.pattern() + ")", 4);

    public static AttrSet parse(String spec) {
        Matcher m = SPEC_PATTERN.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid HDF5 attribute spec format: " + spec);
        }
        AttrSpec attrname = AttrSpec.parse(m.group("attrname"));
        AttrValue attrvalue = AttrValue.parse(m.group("attrvalue"));
        return new AttrSet(attrname, attrvalue);
    }
}

