/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.attrtypes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record AttrSpec(String path, String attr) {
    public static final Pattern SPEC_PATTERN = Pattern.compile("(?<path>/|(?:/[^:/.]+)+)?          # Optional HDF5 path (e.g., /, /group, /group1/group2)\n[:.]?                              # Optional : or . separating path from attribute\n(?<attr>[a-zA-Z_][a-zA-Z0-9_]*)    # Variable name (required, follows identifier rules)\n", 4);

    public AttrSpec {
        if (attr == null || attr.isEmpty()) {
            throw new IllegalArgumentException("attr cannot be null or empty.");
        }
    }

    public static AttrSpec parse(String spec) {
        Matcher m = SPEC_PATTERN.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid HDF5 attribute spec format: " + spec);
        }
        String path = m.group("path") != null ? m.group("path").trim() : "/";
        String attr = m.group("attr");
        return new AttrSpec(path, attr);
    }
}

