/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.attrtypes;

import io.nosqlbench.nbvectors.taghdf.attrtypes.ValueType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record AttrValue<T>(ValueType type, String literal, T value) {
    public static final Pattern SPEC_PATTERN = Pattern.compile("(?:\\((?<typename>[a-zA-Z0-9_]+)\\))?    # Optional type hint (e.g., (String), (int))\n(?<literal>.+)                           # Value (required, captures everything after type hint or =)\n", 4);

    public AttrValue {
        if (literal == null || literal.isEmpty()) {
            throw new IllegalArgumentException("value name cannot be null or empty.");
        }
    }

    public static <T> AttrValue<T> parse(String spec) {
        Matcher m = SPEC_PATTERN.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid HDF5 value spec format: " + spec);
        }
        String typename = m.group("typename") != null ? m.group("typename").trim() : "";
        String literal = m.group("literal");
        ValueType type = typename.isEmpty() ? ValueType.fromLiteral(literal) : ValueType.valueOf(typename.toUpperCase());
        Object value = type.parse(literal);
        return new AttrValue(type, literal, value);
    }
}

