/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.attrtypes;

public enum ValueType {
    BYTE((Class)Byte.class){

        public Byte parse(String value) {
            return Byte.parseByte(value.endsWith("B") || value.endsWith("b") ? value.substring(0, value.length() - 1) : value);
        }
    }
    ,
    INT((Class)Integer.class){

        public Integer parse(String value) {
            return Integer.parseInt(value.endsWith("I") || value.endsWith("i") ? value.substring(0, value.length() - 1) : value);
        }
    }
    ,
    LONG((Class)Long.class){

        public Long parse(String value) {
            return Long.parseLong(value.endsWith("L") || value.endsWith("l") ? value.substring(0, value.length() - 1) : value);
        }
    }
    ,
    SHORT((Class)Short.class){

        public Short parse(String value) {
            return Short.parseShort(value.endsWith("S") || value.endsWith("s") ? value.substring(0, value.length() - 1) : value);
        }
    }
    ,
    FLOAT((Class)Float.class){

        public Float parse(String value) {
            return Float.valueOf(Float.parseFloat(value.endsWith("F") || value.endsWith("f") ? value.substring(0, value.length() - 1) : value));
        }
    }
    ,
    DOUBLE((Class)Double.class){

        public Double parse(String value) {
            return Double.parseDouble(value.endsWith("D") || value.endsWith("d") ? value.substring(0, value.length() - 1) : value);
        }
    }
    ,
    STRING((Class)String.class){

        public String parse(String value) {
            return value;
        }
    };

    public final Class<?> type;

    private ValueType(Class<?> type) {
        this.type = type;
    }

    public abstract <T> T parse(String var1);

    public static ValueType fromLiteral(String value) {
        if (value.matches("[+-]?\\d+[bB]")) {
            return BYTE;
        }
        if (value.matches("[+-]?\\d{10,}")) {
            return LONG;
        }
        if (value.matches("[+-]?\\d+[lL]")) {
            return LONG;
        }
        if (value.matches("[+-]?\\d+[sS]")) {
            return SHORT;
        }
        if (value.matches("[+-]?\\d+[iI]?")) {
            return INT;
        }
        if (value.matches("[+-]?\\d+\\.\\d+") & value.chars().filter(Character::isDigit).count() <= 7L) {
            return FLOAT;
        }
        if (value.matches("[+-]?\\d+\\.\\d+") & value.chars().filter(Character::isDigit).count() > 7L) {
            return DOUBLE;
        }
        if (value.matches("[+-]?\\d+(\\.\\d+)?[fF]")) {
            return FLOAT;
        }
        if (value.matches("[+-]?\\d+(\\.\\d+)?[dD]")) {
            return DOUBLE;
        }
        return STRING;
    }

    private int countDigits(String value) {
        return (int)value.chars().filter(Character::isDigit).count();
    }
}

