/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.traversal;

import io.jhdf.CommittedDatatype;
import io.jhdf.HdfFile;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.nosqlbench.nbvectors.taghdf.traversal.filters.BaseHdfVisitorFilter;
import io.nosqlbench.nbvectors.taghdf.traversal.filters.HdfVisitorFilter;
import io.nosqlbench.nbvectors.taghdf.traversal.injectors.BaseHdfVisitorInjector;
import io.nosqlbench.nbvectors.taghdf.traversal.injectors.HdfVisitorInjector;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.HdfVisitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class HdfTraverser {
    private final HdfVisitorFilter filter;

    public HdfTraverser() {
        this(new BaseHdfVisitorFilter(), new BaseHdfVisitorInjector());
    }

    public HdfTraverser(HdfVisitorFilter filter) {
        this(filter, new BaseHdfVisitorInjector());
    }

    public HdfTraverser(HdfVisitorInjector injector) {
        this(new BaseHdfVisitorFilter(), injector);
    }

    public HdfTraverser(HdfVisitorFilter filter, HdfVisitorInjector injector) {
        this.filter = filter;
    }

    public void traverse(Node node, HdfVisitor traverser) {
        if (this.filter.enterNode(node)) {
            traverser.enterNode(node);
            Node node2 = node;
            Objects.requireNonNull(node2);
            Node node3 = node2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HdfFile.class, Group.class, Dataset.class, CommittedDatatype.class}, (Node)node3, n)) {
                case 0: {
                    HdfFile file = (HdfFile)node3;
                    if (!this.filter.enterFile(file)) break;
                    traverser.enterFile(file);
                    for (Node fileElement : file.getChildren().values()) {
                        this.traverse(fileElement, traverser);
                    }
                    traverser.leaveFile(file);
                    break;
                }
                case 1: {
                    Group group = (Group)node3;
                    if (!this.filter.enterGroup(group)) break;
                    traverser.enterGroup(group);
                    for (Node groupElement : group.getChildren().values()) {
                        this.traverse(node, traverser);
                    }
                    traverser.leaveGroup(group);
                    break;
                }
                case 2: {
                    Dataset dataset = (Dataset)node3;
                    if (!this.filter.dataset(dataset)) break;
                    traverser.dataset(dataset);
                    break;
                }
                case 3: {
                    CommittedDatatype cdt = (CommittedDatatype)node3;
                    if (!this.filter.committedDataType(cdt)) break;
                    traverser.committedDataType(cdt);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized node type: " + String.valueOf(node));
                }
            }
            traverser.leaveNode(node);
        }
    }
}

