/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.traversal.visitors;

import io.jhdf.CommittedDatatype;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.BaseHdfVisitor;
import java.util.Arrays;
import java.util.LinkedList;

public class HdfPrintVisitor
extends BaseHdfVisitor {
    LinkedList<String> names = new LinkedList();

    @Override
    public void enterNode(Node node) {
        this.names.addLast(node.getName());
        String path = String.join((CharSequence)"/", this.names);
        System.out.println("name:" + path + "\ntype: " + node.getType().name());
    }

    @Override
    public void leaveNode(Node node) {
        this.names.removeLast();
    }

    @Override
    public void dataset(Dataset dataset) {
        System.out.println("    dims: DIMS\n    type: HDFTYPE\njavatype: JAVATYPE\ndatasize: DATASIZE\n storage: STORAGESIZE\n".replaceAll("DIMS", Arrays.toString(dataset.getDimensions())).replaceAll("HDFTYPE", dataset.getDataType().getClass().getSimpleName()).replaceAll("JAVATYPE", dataset.getJavaType().getTypeName()).replaceAll("DATASIZE", String.valueOf(dataset.getSize())).replaceAll("STORAGESIZE", String.valueOf(dataset.getStorageInBytes())));
    }

    @Override
    public void attribute(Node node, Attribute attribute) {
        System.out.println(attribute.toString());
    }

    @Override
    public void committedDataType(CommittedDatatype cdt) {
        System.out.println("  datatype: HDFTYPE\n".replaceAll("HDFTYPE", cdt.getDataType().getClass().getSimpleName()));
    }

    @Override
    public void enterGroup(Group group) {
        System.out.println(group.toString());
    }

    @Override
    public void finish() {
    }
}

