/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.traversal.visitors;

import io.jhdf.WritableHdfFile;
import io.jhdf.api.Node;
import io.nosqlbench.nbvectors.taghdf.attrtypes.AttrSet;
import io.nosqlbench.nbvectors.taghdf.traversal.visitors.BaseHdfVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HdfSetAttributesVisitor
extends BaseHdfVisitor {
    private final Map<String, Map<String, AttrSet>> attrs = new HashMap<String, Map<String, AttrSet>>();
    private final WritableHdfFile out;

    public HdfSetAttributesVisitor(WritableHdfFile out, List<String> specifiers) {
        this.out = out;
        for (String specifier : specifiers) {
            AttrSet entry2 = AttrSet.parse(specifier);
            Map nodemap = this.attrs.computeIfAbsent(entry2.attrname().path(), k -> new HashMap());
            nodemap.put(entry2.attrname().attr(), entry2);
        }
    }

    @Override
    public void enterNode(Node node) {
        if (this.attrs.containsKey(node.getName())) {
            this.out.putAttribute(node.getName(), (Object)node.getName());
            Map<String, AttrSet> nodemap = this.attrs.remove(node.getName());
            for (AttrSet entry2 : nodemap.values()) {
                System.out.println("setting attr: " + String.valueOf(entry2));
            }
        }
        super.enterNode(node);
    }

    @Override
    public void finish() {
        if (!this.attrs.isEmpty()) {
            throw new RuntimeException("Not all attributes were set: " + String.valueOf(this.attrs));
        }
    }
}

