/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.taghdf.traversalv2;

import io.jhdf.CommittedDatatype;
import io.jhdf.HdfFile;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.WritableGroup;
import io.nosqlbench.nbvectors.taghdf.traversalv2.HdfTransformer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TransformWalker {
    private final WritableGroup out;
    private final HdfTransformer transformer;
    private final boolean walknew;

    public TransformWalker(WritableGroup out, HdfTransformer transformer, boolean walknew) {
        this.out = out;
        this.transformer = transformer;
        this.walknew = walknew;
    }

    public void traverseNode(Node node, Node parent) {
        Map attributes1 = node.getAttributes();
        for (Attribute attribute : attributes1.values()) {
            List<Attribute> attributes = this.transformer.transformAttribute(parent, attribute);
            attributes = attributes == null ? List.of(attribute) : attributes;
            for (Attribute attr : attributes) {
                this.out.putAttribute(attr.getName(), attr.getData());
            }
        }
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HdfFile.class, Group.class, Attribute.class, Dataset.class, CommittedDatatype.class}, (Node)node3, n)) {
            case 0: {
                HdfFile file = (HdfFile)node3;
                for (Node child : file.getChildren().values()) {
                    this.traverseNode(child, node);
                }
                break;
            }
            case 1: {
                Group group = (Group)node3;
                List<Group> update = this.transformer.transformGroup(parent, group);
                update = update == null ? List.of(group) : update;
                for (Group updatedGroup : update) {
                    this.out.putGroup(updatedGroup.getName());
                }
                break;
            }
            case 2: {
                Attribute attribute = (Attribute)node3;
                List<Attribute> attributes = this.transformer.transform(attribute);
                for (Attribute updatedAttribute : attributes == null ? List.of(attribute) : attributes) {
                    if (attributes != null && this.walknew) {
                        for (Attribute attribute2 : attributes) {
                        }
                    }
                    this.out.putAttribute(updatedAttribute.getName(), updatedAttribute.getData());
                }
                break;
            }
            case 3: {
                Dataset dataset = (Dataset)node3;
                List<Dataset> datasets = this.transformer.transform(dataset);
                datasets = datasets == null ? List.of(dataset) : datasets;
                for (Dataset updatedDataset : datasets) {
                    this.out.putDataset(updatedDataset.getName(), updatedDataset.getData());
                }
                break;
            }
            case 4: {
                CommittedDatatype cdt = (CommittedDatatype)node3;
                List<CommittedDatatype> cdtypes = this.transformer.transform(cdt);
                cdtypes = cdtypes == null ? List.of(cdt) : cdtypes;
                Iterator<CommittedDatatype> iterator = cdtypes.iterator();
                if (!iterator.hasNext()) break;
                CommittedDatatype updatedCdt = iterator.next();
                throw new RuntimeException("Unsupported type until HDF API supports it (CommittedDataType)");
            }
            default: {
                throw new RuntimeException("Unrecognized node type: " + String.valueOf(node));
            }
        }
    }
}

