/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.computation;

import io.nosqlbench.nbvectors.verifyknn.datatypes.BitImage;
import java.util.Arrays;
import java.util.BitSet;

public class Computations {
    public static int SET_A = 0;
    public static int SET_BOTH = 1;
    public static int SET_B = 2;

    public static long[][] partitions(long[] provided, long[] expected) {
        Arrays.sort(provided);
        Arrays.sort(expected);
        int a_index = 0;
        int b_index = 0;
        long[] common_view = new long[provided.length + expected.length];
        long[] a_view = new long[provided.length + expected.length];
        long[] b_view = new long[provided.length + expected.length];
        int cursor = 0;
        int a_bufidx = 0;
        int b_bufidx = 0;
        int c_bufidx = 0;
        while (a_index < provided.length && b_index < expected.length) {
            long a_element = provided[a_index];
            long b_element = expected[b_index];
            if (a_element == b_element) {
                common_view[c_bufidx++] = a_element;
                ++a_index;
                ++b_index;
            } else if (b_element < a_element) {
                b_view[b_bufidx++] = b_element;
                ++b_index;
            } else {
                a_view[a_bufidx++] = a_element;
                ++a_index;
            }
            ++cursor;
        }
        a_view = Arrays.copyOf(a_view, a_bufidx);
        b_view = Arrays.copyOf(b_view, b_bufidx);
        common_view = Arrays.copyOf(common_view, c_bufidx);
        return new long[][]{a_view, common_view, b_view};
    }

    public static BitImage matchingImage(long[] expected_ary, long[] provided_ary) {
        Arrays.sort(expected_ary);
        int expected_idx = 0;
        Arrays.sort(provided_ary);
        int provided_idx = 0;
        BitImage matching_bits = new BitImage(expected_ary.length);
        while (provided_idx < provided_ary.length && expected_idx < expected_ary.length) {
            long provided_data = provided_ary[provided_idx];
            long expected_data = expected_ary[expected_idx];
            if (provided_data == expected_data) {
                matching_bits.set(expected_idx);
                ++provided_idx;
                ++expected_idx;
                continue;
            }
            if (expected_data < provided_data) {
                ++expected_idx;
                continue;
            }
            ++provided_idx;
        }
        while (expected_idx < expected_ary.length) {
            matching_bits.setZero(expected_idx);
            ++expected_idx;
        }
        return matching_bits;
    }

    public static BitSetDelta bitmaps(long[] a, long[] b) {
        Arrays.sort(a);
        Arrays.sort(b);
        int a_index = 0;
        int b_index = 0;
        BitSet aBits = new BitSet(a.length);
        BitSet bBits = new BitSet(b.length);
        int position = 0;
        while (a_index < a.length && b_index < b.length) {
            long a_element = a[a_index];
            long b_element = b[b_index];
            if (a_element == b_element) {
                aBits.set(position);
                bBits.set(position);
                ++a_index;
                ++b_index;
            } else if (b_element < a_element) {
                bBits.set(position);
                ++b_index;
            } else {
                aBits.set(position);
                ++a_index;
            }
            ++position;
        }
        return new BitSetDelta(aBits, bBits);
    }

    public record BitSetDelta(BitSet provided, BitSet expected) {
    }
}

