/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.computation;

import io.nosqlbench.nbvectors.verifyknn.computation.Computations;
import io.nosqlbench.nbvectors.verifyknn.datatypes.LongIndexedFloatVector;
import io.nosqlbench.nbvectors.verifyknn.datatypes.Neighborhood;
import io.nosqlbench.nbvectors.verifyknn.statusview.Glyphs;

public record NeighborhoodComparison(LongIndexedFloatVector testVector, Neighborhood providedNeighborhood, Neighborhood expectedNeighborhood) {
    public boolean isError() {
        long[][] partitions = Computations.partitions(this.providedNeighborhood.getIndices(), this.expectedNeighborhood.getIndices());
        return partitions[Computations.SET_A].length > 0 || partitions[Computations.SET_B].length > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long[][] partitions = Computations.partitions(this.providedNeighborhood.getIndices(), this.expectedNeighborhood.getIndices());
        sb.append(partitions[Computations.SET_A].length == 0 ? "PASS " : "FAIL ");
        sb.append("[");
        sb.append(Glyphs.braille(Computations.matchingImage(this.expectedNeighborhood().getIndices(), this.providedNeighborhood.getIndices())));
        sb.append("]");
        sb.append(String.format(" (extra,matching,missing)=(%d,%d,%d)", partitions[Computations.SET_A].length, partitions[Computations.SET_BOTH].length, partitions[Computations.SET_B].length));
        sb.append("\n");
        return sb.toString();
    }
}

