/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.datatypes;

import java.util.Comparator;

public record LongIndexedFloatVector(long index, float[] vector) implements Comparable<LongIndexedFloatVector>
{
    public static Comparator<LongIndexedFloatVector> BY_VECTOR_SHAPE = new Comparator<LongIndexedFloatVector>(){

        @Override
        public int compare(LongIndexedFloatVector o1, LongIndexedFloatVector o2) {
            int range = Math.min(o1.vector.length, o2.vector.length);
            for (int i = 0; i < range; ++i) {
                int diff = Double.compare(o1.vector[i], o2.vector[i]);
                if (diff == 0) continue;
                return diff;
            }
            if (o1.vector.length > range) {
                return -1;
            }
            if (o2.vector.length > range) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public int compareTo(LongIndexedFloatVector o) {
        return Long.compare(this.index, o.index);
    }

    @Override
    public String toString() {
        return "query(" + this.index + "):float[" + this.vector.length + "] " + String.format("%+1.3f %+1.3f %+1.3f", Float.valueOf(this.vector[0]), Float.valueOf(this.vector[1]), Float.valueOf(this.vector[2])) + "...";
    }
}

