/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.options;

public enum DistanceFunction {
    COSINE;


    public double distance(double[] v1, double[] v2) {
        switch (this.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return this.doubleCosineDistance(v1, v2);
    }

    public double distance(float[] v1, float[] v2) {
        switch (this.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return this.floatCosineDistance(v1, v2);
    }

    private double floatCosineDistance(float[] vectorA, float[] vectorB) {
        if (vectorA == null || vectorB == null || vectorA.length != vectorB.length) {
            throw new IllegalArgumentException("Vectors must be non-null and of the same dimension.");
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            dotProduct += (double)(vectorA[i] * vectorB[i]);
            normA += (double)(vectorA[i] * vectorA[i]);
            normB += (double)(vectorB[i] * vectorB[i]);
        }
        double magnitudeA = Math.sqrt(normA);
        double magnitudeB = Math.sqrt(normB);
        if (magnitudeA == 0.0 || magnitudeB == 0.0) {
            throw new IllegalArgumentException("One of the vectors has zero magnitude.");
        }
        double cosineSimilarity = dotProduct / (magnitudeA * magnitudeB);
        return 1.0 - cosineSimilarity;
    }

    private double doubleCosineDistance(double[] vectorA, double[] vectorB) {
        if (vectorA == null || vectorB == null || vectorA.length != vectorB.length) {
            throw new IllegalArgumentException("Vectors must be non-null and of the same dimension.");
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            dotProduct += vectorA[i] * vectorB[i];
            normA += vectorA[i] * vectorA[i];
            normB += vectorB[i] * vectorB[i];
        }
        double magnitudeA = Math.sqrt(normA);
        double magnitudeB = Math.sqrt(normB);
        if (magnitudeA == 0.0 || magnitudeB == 0.0) {
            throw new IllegalArgumentException("One of the vectors has zero magnitude.");
        }
        double cosineSimilarity = dotProduct / (magnitudeA * magnitudeB);
        return 1.0 - cosineSimilarity;
    }
}

