/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.options;

import io.nosqlbench.nbvectors.verifyknn.options.Interval;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picocli.CommandLine;

public class IntervalParser
implements CommandLine.ITypeConverter<Interval> {
    static final Pattern format = Pattern.compile("^((?<minIncl>\\d+)\\.\\.)?(?<maxExcl>\\d+)$");

    public Interval convert(String value) {
        Matcher matcher = format.matcher(value);
        if (matcher.matches()) {
            String minIncl = matcher.group("minIncl");
            minIncl = minIncl != null ? minIncl : "0";
            String maxExcl = matcher.group("maxExcl");
            return new Interval(Long.parseLong(minIncl), Long.parseLong(maxExcl));
        }
        throw new IllegalArgumentException("Invalid interval: " + value);
    }
}

