/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.readers;

import io.jhdf.HdfFile;
import io.jhdf.api.Dataset;
import io.nosqlbench.nbvectors.verifyknn.datatypes.LongIndexedFloatVector;
import io.nosqlbench.nbvectors.verifyknn.datatypes.NeighborIndex;
import io.nosqlbench.nbvectors.verifyknn.datatypes.Neighborhood;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record KNNData(Dataset test, Dataset train, Dataset neighbors, Dataset distances, HdfFile hdfFile) implements AutoCloseable
{
    public KNNData(HdfFile hdfFile) {
        this(hdfFile.getDatasetByPath("/test"), hdfFile.getDatasetByPath("/train"), hdfFile.getDatasetByPath("/neighbors"), hdfFile.getDatasetByPath("/distances"), hdfFile);
    }

    @Override
    public void close() throws Exception {
        this.hdfFile.close();
    }

    public LongIndexedFloatVector readHdf5TestVector(long index) {
        int[] testVectorDimensions = this.test().getDimensions();
        long[] testVectorOffsets = new long[testVectorDimensions.length];
        testVectorDimensions[0] = 1;
        testVectorOffsets[0] = index;
        Object testVectorData = this.test().getData(testVectorOffsets, testVectorDimensions);
        float[] testVector = ((float[][])testVectorData)[0];
        return new LongIndexedFloatVector(index, testVector);
    }

    public Neighborhood[] neighborhoods(long minIncluded, long maxExcluded) {
        Neighborhood[] neighborhoods = new Neighborhood[(int)(maxExcluded - minIncluded)];
        for (int i = 0; i < neighborhoods.length; ++i) {
            neighborhoods[i] = this.neighborhood(minIncluded + (long)i);
        }
        return neighborhoods;
    }

    public Neighborhood neighborhood(long ordinal) {
        Object neighborsData;
        Neighborhood answerKey = new Neighborhood();
        Dataset neighbors = this.neighbors();
        Dataset distances = this.distances();
        int[] dimensions = neighbors.getDimensions();
        long[] sliceOffset = new long[dimensions.length];
        sliceOffset[0] = ordinal;
        dimensions[0] = 1;
        Object object = neighborsData = neighbors.getData(sliceOffset, dimensions);
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        long[] neighborIndices = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{long[][].class, int[][].class}, (Object)object2, n)) {
            case 0 -> {
                long[][] longdata = (long[][])object2;
                yield longdata[0];
            }
            case 1 -> {
                int[][] intData = (int[][])object2;
                long[] ary = new long[intData[0].length];
                for (int i = 0; i < ary.length; ++i) {
                    ary[i] = intData[0][i];
                }
                yield ary;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(neighborsData));
        };
        Object distancesData = distances.getData(sliceOffset, dimensions);
        float[] neighborDistances = ((float[][])distancesData)[0];
        for (int i = 0; i < neighborDistances.length; ++i) {
            answerKey.add(new NeighborIndex(neighborIndices[i], neighborDistances[i]));
        }
        return answerKey;
    }

    public float[] train(int testVectorOrdinal) {
        int[] trainVectorDimensions = this.train().getDimensions();
        trainVectorDimensions[0] = 1;
        long[] trainVectorOffsets = new long[trainVectorDimensions.length];
        trainVectorOffsets[0] = testVectorOrdinal;
        Object trainVectorData = this.train().getData(trainVectorOffsets, trainVectorDimensions);
        return ((float[][])trainVectorData)[0];
    }

    public int trainingVectorCount() {
        return this.train().getDimensions()[0];
    }
}

