/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.statusview;

import io.nosqlbench.nbvectors.verifyknn.datatypes.BitImage;
import java.util.BitSet;

public class Glyphs {
    static final int BRAILLE_BASE = 10240;

    public static String braille(BitSet bits) {
        byte[] bary = bits.toByteArray();
        return Glyphs.braille(bary);
    }

    public static String braille(BitImage bits) {
        byte[] bary = bits.toByteArray();
        return Glyphs.braille(bary);
    }

    public static String braille(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Glyphs.braille(b));
        }
        return sb.toString();
    }

    public static char braille(int v) {
        return Glyphs.braille((byte)v);
    }

    public static char braille(byte b) {
        int bits = Byte.toUnsignedInt(b);
        int image = bits & 7 | (bits & 8) << 3 | (bits & 0x70) >> 1 | bits & 0x80;
        char braille = (char)(10240 + image);
        return braille;
    }

    public static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i % 4 == 0) {
                sb.append(" ");
            } else {
                sb.append(".");
            }
            sb.append(String.format("%02X", bytes[i]));
        }
        return sb.toString();
    }
}

