/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.statusview;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.BasicTextImage;
import com.googlecode.lanterna.graphics.SimpleTheme;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.ProgressBar;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTerminal;
import com.googlecode.lanterna.terminal.ansi.UnixTerminal;
import com.googlecode.lanterna.terminal.virtual.DefaultVirtualTerminal;
import io.nosqlbench.nbvectors.verifyknn.computation.NeighborhoodComparison;
import io.nosqlbench.nbvectors.verifyknn.datatypes.LongIndexedFloatVector;
import io.nosqlbench.nbvectors.verifyknn.statusview.StatusView;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class StatusViewLanterna
implements AutoCloseable,
StatusView {
    private final Terminal terminal;
    private final TerminalScreen screen;
    private final MultiWindowTextGUI gui;
    private final int summaries;
    private BasicWindow statusWindow;
    private Panel content;
    private ProgressBar intervalProgress;
    private ProgressBar chunkProgress;
    private TextBox[] lastComparisonText;
    private BasicTextImage textimage;
    private LongIndexedFloatVector lastQueryVector;
    private int totalQueryVectors;
    private int currentQueryVector;
    int update = 0;

    public StatusViewLanterna(int summaries) {
        this.summaries = summaries;
        this.lastComparisonText = new TextBox[summaries];
        UnixTerminal terminal = null;
        try {
            terminal = new UnixTerminal(System.in, (OutputStream)System.out, StandardCharsets.UTF_8, UnixLikeTerminal.CtrlCBehaviour.CTRL_C_KILLS_APPLICATION);
        }
        catch (IOException e) {
            System.err.println("Unable to create terminal, using virtual terminal instead");
            terminal = new DefaultVirtualTerminal();
        }
        this.terminal = terminal;
        try {
            this.screen = new TerminalScreen((Terminal)terminal);
            this.screen.startScreen();
            this.gui = new MultiWindowTextGUI((Screen)this.screen, (WindowManager)new DefaultWindowManager(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.initLayout();
    }

    @Override
    public void close() throws Exception {
        this.screen.stopScreen(true);
        this.screen.close();
    }

    private void initLayout() {
        this.statusWindow = new BasicWindow("Status");
        this.statusWindow.setHints(List.of(Window.Hint.FIT_TERMINAL_WINDOW, Window.Hint.NO_DECORATIONS));
        this.gui.addWindow((Window)this.statusWindow);
        this.content = new Panel((LayoutManager)new LinearLayout(Direction.VERTICAL));
        SimpleTheme customtheme = SimpleTheme.makeTheme((boolean)true, (TextColor)new TextColor.RGB(51, 200, 0), (TextColor)new TextColor.RGB(40, 40, 40), (TextColor)new TextColor.RGB(200, 180, 220), (TextColor)new TextColor.RGB(80, 80, 80), (TextColor)new TextColor.RGB(200, 200, 200), (TextColor)new TextColor.RGB(100, 100, 100), (TextColor)new TextColor.RGB(40, 40, 40));
        this.gui.setTheme((Theme)customtheme);
        this.content.addComponent((Component)new Label("NBVector: KNN Answer Key Verifier"));
        this.statusWindow.setComponent((Component)this.content);
        this.intervalProgress = new ProgressBar(0, 100, this.screen.getTerminalSize().getColumns());
        this.content.addComponent((Component)this.intervalProgress);
        this.chunkProgress = new ProgressBar(0, 100, this.screen.getTerminalSize().getColumns());
        this.content.addComponent((Component)this.chunkProgress);
        for (int i = 0; i < this.summaries; ++i) {
            this.lastComparisonText[i] = new TextBox(new TerminalSize(this.screen.getTerminalSize().getColumns(), 3));
            this.content.addComponent((Component)this.lastComparisonText[i]);
        }
        try {
            this.gui.updateScreen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        KeyStroke keyStroke = StatusViewLanterna.this.screen.readInput();
                        System.out.println(keyStroke);
                        StatusViewLanterna.this.screen.refresh();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    @Override
    public void onStart(int totalQueryVectors) {
        this.totalQueryVectors = totalQueryVectors;
    }

    @Override
    public void onChunk(int chunk, int chunkSize, int totalTrainingVectors) {
        this.chunkProgress.setLabelFormat("chunk " + chunk + "/" + totalTrainingVectors + " (%2.0f%%)");
        this.chunkProgress.setMax(totalTrainingVectors);
        this.chunkProgress.setValue(chunk);
        try {
            this.gui.updateScreen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onQueryVector(LongIndexedFloatVector vector, long index, long end) {
        ++this.currentQueryVector;
        this.lastQueryVector = vector;
        this.intervalProgress.setMax(this.totalQueryVectors);
        this.intervalProgress.setValue(this.currentQueryVector);
        this.intervalProgress.setLabelFormat("query " + this.currentQueryVector + "/" + this.totalQueryVectors + " index[" + index + "] (%2.0f%%)");
        int modulo = (int)(vector.index() % (long)this.summaries);
        this.lastComparisonText[modulo].setText(this.lastQueryVector.toString());
        try {
            this.gui.updateScreen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onNeighborhoodComparison(NeighborhoodComparison comparison) {
        int modulo = (int)(comparison.testVector().index() % (long)this.summaries);
        this.lastComparisonText[modulo].setText(String.valueOf(this.lastQueryVector) + "\n" + comparison.toString());
        try {
            this.gui.updateScreen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
    }
}

