/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.verifyknn.statusview;

import io.nosqlbench.nbvectors.verifyknn.computation.NeighborhoodComparison;
import io.nosqlbench.nbvectors.verifyknn.datatypes.LongIndexedFloatVector;
import io.nosqlbench.nbvectors.verifyknn.statusview.StatusView;

public class StatusViewStdout
implements StatusView {
    private int totalQueryVectors;
    private int currentQueryVector;
    private int errors = 0;
    StringBuilder sb = new StringBuilder();
    boolean flushall = false;

    public StatusViewStdout(boolean flushall) {
        this.flushall = flushall;
    }

    @Override
    public void onStart(int totalQueryVectors) {
        this.totalQueryVectors = totalQueryVectors;
        this.sb.append("Total query vectors: ").append(totalQueryVectors).append("\n");
        this.flushIf();
    }

    private synchronized void flushIf() {
        if (this.flushall) {
            System.out.print(this.sb.toString());
            this.sb.setLength(0);
        }
    }

    @Override
    public void onQueryVector(LongIndexedFloatVector vector, long index, long end) {
        this.sb.append(++this.currentQueryVector).append("/").append(this.totalQueryVectors).append(": ");
        this.sb.append(vector);
        this.flushIf();
    }

    @Override
    public void onChunk(int chunk, int chunkSize, int totalTrainingVectors) {
        if (chunk == 0) {
            this.sb.append("chunks/").append(chunkSize).append(" ");
        }
        this.sb.append(".");
        this.flushIf();
    }

    @Override
    public void onNeighborhoodComparison(NeighborhoodComparison comparison) {
        this.sb.append("\n");
        this.sb.append(comparison).append("\n");
        this.errors += comparison.isError() ? 1 : 0;
        this.flushIf();
    }

    @Override
    public void end() {
        this.sb.append("(pass,fail,total)=(").append(this.totalQueryVectors - this.errors).append(",").append(this.errors).append(",").append(this.totalQueryVectors).append(")").append("\n");
        this.flushIf();
    }

    @Override
    public void close() throws Exception {
        System.out.print(this.sb.toString());
    }
}

