/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.commands;

import io.nosqlbench.nbdatatools.api.services.BundledCommand;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class AddBundledCommands
implements CommandLine.IModelTransformer {
    private static final Logger logger = LogManager.getLogger(AddBundledCommands.class);

    public CommandLine.Model.CommandSpec transform(CommandLine.Model.CommandSpec commandSpec) {
        ServiceLoader<BundledCommand> load = ServiceLoader.load(BundledCommand.class);
        Set extant = commandSpec.subcommands().keySet();
        load.stream().filter(c -> {
            CommandLine.Command canno = c.type().getAnnotation(CommandLine.Command.class);
            if (canno == null) {
                return false;
            }
            if (extant.contains(canno.name())) {
                throw new RuntimeException("Command name '" + canno.name() + "' is already defined, but found another under the same name in services manifest.");
            }
            return true;
        }).forEach(c -> {
            CommandLine.Command canno = c.type().getAnnotation(CommandLine.Command.class);
            Objects.requireNonNull(canno);
            String name = canno.name();
            CommandLine cl = new CommandLine(c.type());
            commandSpec.addSubcommand(name, cl);
        });
        return commandSpec;
    }
}

