/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.layout;

import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.BoundedPageStore;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class PageSupplier
implements Supplier<BoundedPageStore>,
AutoCloseable {
    private final MessageColumnIO columnIO;
    private final ParquetFileReader parquetFileReader;
    private final GroupRecordConverter groupRecordConverter;

    public PageSupplier(InputFile inf) {
        try {
            this.parquetFileReader = ParquetFileReader.open((InputFile)inf);
            ParquetMetadata parquetMetadata = this.parquetFileReader.getFooter();
            MessageType messageType = parquetMetadata.getFileMetaData().getSchema();
            this.columnIO = new ColumnIOFactory().getColumnIO(messageType);
            this.groupRecordConverter = new GroupRecordConverter(messageType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BoundedPageStore get() {
        PageReadStore pageReadStore = null;
        try {
            pageReadStore = this.parquetFileReader.readNextRowGroup();
            if (pageReadStore == null) {
                return null;
            }
            return new BoundedPageStore(pageReadStore, this.columnIO, (RecordMaterializer<Group>)this.groupRecordConverter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.parquetFileReader.close();
    }
}

