/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.layout;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class PathAggregator {
    private static final WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{"*.parquet"}).get();
    private static final WildcardFileFilter pathFilter = WildcardFileFilter.builder().setWildcards(new String[]{"*"}).get();
    private final Path root;
    private final boolean recurse;
    private AccumulatorPathVisitor pv = AccumulatorPathVisitor.withLongCounters((PathFilter)fileFilter, (PathFilter)pathFilter);

    public PathAggregator(Path root, boolean recurse) {
        this.root = root;
        this.recurse = recurse;
        try {
            Set options = Set.of();
            Files.walkFileTree(root, Set.of(FileVisitOption.FOLLOW_LINKS), recurse ? 100 : 1, (FileVisitor<? super Path>)this.pv);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTotalSizeInBytes() {
        return this.pv.getPathCounters().getByteCounter().getLong();
    }

    public Path getRootPath() {
        return this.root;
    }

    public List<Path> getFileList() {
        return this.pv.getFileList();
    }

    public List<Path> getDirList() {
        return this.pv.getDirList();
    }
}

