/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.layout;

import io.nosqlbench.nbvectors.datasource.parquet.layout.PathAggregator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class PathsSorter
implements Iterable<PathAggregator> {
    private final List<PathAggregator> entries = new ArrayList<PathAggregator>();
    public static final Comparator<PathAggregator> BY_REVERSE_TOTAL_SIZE = Collections.reverseOrder(Comparator.comparingLong(PathAggregator::getTotalSizeInBytes));
    public static final Comparator<PathAggregator> BY_TOTAL_SIZE = Comparator.comparingLong(PathAggregator::getTotalSizeInBytes);
    public static final Comparator<PathAggregator> BY_NAME = Comparator.comparing(pt -> pt.getRootPath().toString());

    public PathsSorter(List<Path> paths, boolean recurse) {
        for (Path path : paths) {
            PathAggregator traverser = new PathAggregator(path, recurse);
            this.entries.add(traverser);
        }
    }

    public PathsSorter(Collection<? extends Path> paths) {
        this(paths, true);
    }

    public PathsSorter(Collection<? extends Path> paths, boolean recurse) {
        this((List<Path>)new ArrayList<Path>(paths), recurse);
    }

    public SortedResults sorted() {
        return this.sorted(BY_REVERSE_TOTAL_SIZE, BY_NAME);
    }

    public SortedResults sorted(Comparator<PathAggregator> ... inOrder) {
        OrderedComparator oc = new OrderedComparator(inOrder);
        this.entries.sort(oc);
        return new SortedResults(this.entries);
    }

    @Override
    public Iterator<PathAggregator> iterator() {
        return this.entries.iterator();
    }

    public static final class SortedResults
    extends ArrayList<PathAggregator> {
        public SortedResults(List<? extends PathAggregator> c) {
            super(c);
        }

        public List<Path> toPaths() {
            return this.stream().map(PathAggregator::getRootPath).collect(Collectors.toList());
        }
    }

    public static class OrderedComparator
    implements Comparator<PathAggregator> {
        private final Comparator<PathAggregator>[] comparators;

        @SafeVarargs
        public OrderedComparator(Comparator<PathAggregator> ... comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(PathAggregator o1, PathAggregator o2) {
            for (Comparator<PathAggregator> comparator : this.comparators) {
                int result = comparator.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

