/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbvectors.datasource.parquet.traversal.functional;

import io.nosqlbench.nbvectors.datasource.parquet.layout.PathAggregator;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.BoundedPageStore;
import io.nosqlbench.nbvectors.datasource.parquet.traversal.functional.ParquetVisitor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.InputFile;

public class ParqueLoggingVisitor
implements ParquetVisitor {
    private static final Logger logger = LogManager.getLogger(ParqueLoggingVisitor.class);
    private final ParquetVisitor inner;
    private final Level level;

    public ParqueLoggingVisitor(ParquetVisitor inner, Level level) {
        this.inner = inner;
        this.level = level;
        logger.log(level, () -> "starting parquet logging visitor for " + String.valueOf(inner) + " at level " + String.valueOf(level));
    }

    @Override
    public void afterAll() {
        logger.log(this.level, () -> "--> afterAll()");
        this.inner.afterAll();
        logger.log(this.level, () -> " <- afterAll()");
    }

    @Override
    public void onGroup(Group group) {
        logger.log(this.level, () -> "--> afterGroup(type=" + String.valueOf(group.getType()) + ")");
        this.inner.onGroup(group);
        logger.log(this.level, () -> " <- afterGroup(type=" + String.valueOf(group.getType()) + ")");
    }

    @Override
    public void afterInputFile(InputFile inputFile) {
        logger.log(this.level, () -> "--> afterInputFile(file=" + inputFile.toString() + ")");
        this.inner.afterInputFile(inputFile);
        logger.log(this.level, () -> " <- afterInputFile(file=" + inputFile.toString() + ")");
    }

    @Override
    public void afterPage(BoundedPageStore pageStore) {
        logger.log(this.level, () -> "--> afterPage(store=" + pageStore.toString() + ")");
        this.inner.afterPage(pageStore);
        logger.log(this.level, () -> "--> afterPage(store=" + pageStore.toString() + ")");
    }

    @Override
    public void afterRoot(PathAggregator rootTraverser) {
        System.out.println("after root " + String.valueOf(rootTraverser.getRootPath().getFileName()));
        logger.log(this.level, () -> "--> afterRoot(traverser=" + rootTraverser.toString() + ")");
        this.inner.afterRoot(rootTraverser);
        logger.log(this.level, () -> " <- afterRoot(traverser=" + rootTraverser.toString() + ")");
    }

    @Override
    public void beforeAll() {
        logger.log(this.level, () -> "--> beforeAll()");
        this.inner.beforeAll();
        logger.log(this.level, () -> " <- beforeAll()");
    }

    @Override
    public void beforeInputFile(InputFile inputFile) {
        logger.log(this.level, () -> "--> beforeInputFile(file=" + String.valueOf(inputFile) + ")");
        this.inner.beforeInputFile(inputFile);
        logger.log(this.level, () -> " <- beforeInputFile(file=" + String.valueOf(inputFile) + ")");
    }

    @Override
    public void beforePage(BoundedPageStore pageStore) {
        logger.log(this.level, () -> "--> beforePage(store=" + String.valueOf(pageStore) + ")");
        this.inner.beforePage(pageStore);
        logger.log(this.level, () -> " <- beforePage(store=" + String.valueOf(pageStore) + ")");
    }

    @Override
    public void beforeRoot(PathAggregator rootTraverser) {
        System.out.println("before root " + String.valueOf(rootTraverser.getRootPath()));
        logger.log(this.level, () -> "--> beforeRoot(path=" + String.valueOf(rootTraverser) + ")");
        this.inner.beforeRoot(rootTraverser);
        logger.log(this.level, () -> " <- beforeRoot(path=" + String.valueOf(rootTraverser) + ")");
    }

    @Override
    public ParquetVisitor.Depth getTraversalDepth() {
        logger.log(this.level, () -> "<-> getTraversalDepth(depth=" + String.valueOf((Object)this.inner.getTraversalDepth()) + ")");
        return this.inner.getTraversalDepth();
    }
}

