/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.concurrent;

import io.nosqlbench.nbdatatools.api.concurrent.ProgressIndicator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class ProgressIndicatingFuture<T>
extends CompletableFuture<T>
implements ProgressIndicator<T> {
    private final CompletableFuture<T> underlying;
    private final Supplier<Double> totalWorkCallback;
    private final Supplier<Double> currentWorkCallback;
    private final double bytesPerUnit;

    public ProgressIndicatingFuture(CompletableFuture<T> underlying, Supplier<Double> totalWorkCallback, Supplier<Double> currentWorkCallback) {
        this(underlying, totalWorkCallback, currentWorkCallback, 1.0);
    }

    public ProgressIndicatingFuture(CompletableFuture<T> underlying, Supplier<Double> totalWorkCallback, Supplier<Double> currentWorkCallback, double bytesPerUnit) {
        this.underlying = underlying;
        this.totalWorkCallback = totalWorkCallback;
        this.currentWorkCallback = currentWorkCallback;
        this.bytesPerUnit = bytesPerUnit;
        underlying.whenComplete((T result, U throwable) -> {
            if (throwable != null) {
                this.completeExceptionally((Throwable)throwable);
            } else {
                this.complete(result);
            }
        });
    }

    @Override
    public double getTotalWork() {
        return this.totalWorkCallback.get();
    }

    @Override
    public double getCurrentWork() {
        return this.currentWorkCallback.get();
    }

    @Override
    public double getBytesPerUnit() {
        return this.bytesPerUnit;
    }
}

