/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.concurrent;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public interface ProgressIndicator<T> {
    public double getTotalWork();

    public double getCurrentWork();

    default public double getBytesPerUnit() {
        return 1.0;
    }

    default public double getProgressPercentage() {
        double total = this.getTotalWork();
        if (total <= 0.0) {
            return 0.0;
        }
        return this.getCurrentWork() / total * 100.0;
    }

    default public double getProgressFraction() {
        double total = this.getTotalWork();
        if (total <= 0.0) {
            return 0.0;
        }
        return this.getCurrentWork() / total;
    }

    default public boolean hasProgress() {
        return this.getCurrentWork() > 0.0;
    }

    default public boolean isWorkComplete() {
        return this.getCurrentWork() >= this.getTotalWork() && this.getTotalWork() > 0.0;
    }

    default public double getRemainingWork() {
        return Math.max(0.0, this.getTotalWork() - this.getCurrentWork());
    }

    default public String getProgressString() {
        double bytesPerUnit = this.getBytesPerUnit();
        if (bytesPerUnit > 1.0) {
            double currentBytes = this.getCurrentWork() * bytesPerUnit;
            double totalBytes = this.getTotalWork() * bytesPerUnit;
            return String.format("%.1f/%.1f chunks (%s/%s, %.1f%%)", this.getCurrentWork(), this.getTotalWork(), this.formatBytes(currentBytes), this.formatBytes(totalBytes), this.getProgressPercentage());
        }
        return String.format("%.1f/%.1f (%.1f%%)", this.getCurrentWork(), this.getTotalWork(), this.getProgressPercentage());
    }

    default public long getEstimatedRemainingTime(TimeUnit unit) {
        return -1L;
    }

    default public ProgressSnapshot getProgressSnapshot() {
        return new ProgressSnapshot(this.getCurrentWork(), this.getTotalWork());
    }

    default public CompletableFuture<Void> monitorProgress(PrintStream outputStream, long intervalMs) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicBoolean interrupted = new AtomicBoolean(false);
            Thread shutdownHook = new Thread(() -> {
                interrupted.set(true);
                if (this instanceof CompletableFuture) {
                    ((CompletableFuture)((Object)this)).cancel(true);
                }
            });
            try {
                long startTime;
                ArrayDeque<ProgressSample> progressHistory = new ArrayDeque<ProgressSample>();
                int MAX_SAMPLES = 10;
                String[] BUSY_CHARS = new String[]{"\u280b", "\u2819", "\u2839", "\u2838", "\u283c", "\u2834", "\u2826", "\u2827", "\u2807", "\u280f"};
                int busyIndex = 0;
                String lastProgressString = null;
                long lastProgressUpdate = startTime = System.currentTimeMillis();
                boolean hasOutput = false;
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                String currentProgressString = this.getEnhancedProgressString(progressHistory, startTime);
                outputStream.print(currentProgressString);
                outputStream.flush();
                lastProgressString = currentProgressString;
                hasOutput = true;
                progressHistory.addLast(new ProgressSample(this.getCurrentWork(), System.currentTimeMillis()));
                if (this instanceof CompletableFuture) {
                    CompletableFuture future = (CompletableFuture)((Object)this);
                    while (!future.isDone() && !interrupted.get()) {
                        try {
                            long busyInterval = Math.min(intervalMs / 4L, 250L);
                            future.get(busyInterval, TimeUnit.MILLISECONDS);
                            break;
                        }
                        catch (TimeoutException e) {
                            long currentTime = System.currentTimeMillis();
                            double currentWork = this.getCurrentWork();
                            if (currentTime - lastProgressUpdate >= intervalMs) {
                                progressHistory.addLast(new ProgressSample(currentWork, currentTime));
                                if (progressHistory.size() > 10) {
                                    progressHistory.removeFirst();
                                }
                                if (!(currentProgressString = this.getEnhancedProgressString(progressHistory, startTime)).equals(lastProgressString)) {
                                    if (hasOutput) {
                                        outputStream.print("\r\u001b[K");
                                    }
                                    outputStream.print(currentProgressString);
                                    outputStream.flush();
                                    lastProgressString = currentProgressString;
                                    hasOutput = true;
                                }
                                lastProgressUpdate = currentTime;
                                continue;
                            }
                            if (hasOutput) {
                                outputStream.print("\r\u001b[K");
                            }
                            outputStream.print(lastProgressString + " " + BUSY_CHARS[busyIndex]);
                            outputStream.flush();
                            busyIndex = (busyIndex + 1) % BUSY_CHARS.length;
                            hasOutput = true;
                        }
                    }
                    if (hasOutput) {
                        outputStream.print("\r\u001b[K");
                    }
                    if (interrupted.get()) {
                        if (!future.isDone() || future.isCancelled()) {
                            outputStream.println("Interrupted by user (Ctrl-C)");
                        } else {
                            outputStream.println(this.getEnhancedProgressString(progressHistory, startTime) + " - Complete");
                        }
                    } else if (future.isCompletedExceptionally() && !future.isCancelled()) {
                        outputStream.println("Task failed");
                    } else if (future.isCancelled()) {
                        outputStream.println("Task cancelled");
                    } else {
                        outputStream.println(this.getEnhancedProgressString(progressHistory, startTime) + " - Complete");
                    }
                } else {
                    while (!this.isWorkComplete() && !interrupted.get()) {
                        try {
                            long busyInterval = Math.min(intervalMs / 4L, 250L);
                            Thread.sleep(busyInterval);
                            long currentTime = System.currentTimeMillis();
                            double currentWork = this.getCurrentWork();
                            if (currentTime - lastProgressUpdate >= intervalMs) {
                                progressHistory.addLast(new ProgressSample(currentWork, currentTime));
                                if (progressHistory.size() > 10) {
                                    progressHistory.removeFirst();
                                }
                                if (!(currentProgressString = this.getEnhancedProgressString(progressHistory, startTime)).equals(lastProgressString)) {
                                    if (hasOutput) {
                                        outputStream.print("\r\u001b[K");
                                    }
                                    outputStream.print(currentProgressString);
                                    outputStream.flush();
                                    lastProgressString = currentProgressString;
                                    hasOutput = true;
                                }
                                lastProgressUpdate = currentTime;
                                continue;
                            }
                            if (hasOutput) {
                                outputStream.print("\r\u001b[K");
                            }
                            outputStream.print(lastProgressString + " " + BUSY_CHARS[busyIndex]);
                            outputStream.flush();
                            busyIndex = (busyIndex + 1) % BUSY_CHARS.length;
                            hasOutput = true;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            if (hasOutput) {
                                outputStream.print("\r\u001b[K");
                            }
                            outputStream.println("Monitoring interrupted");
                            throw new RuntimeException(e);
                        }
                    }
                    if (hasOutput) {
                        outputStream.print("\r\u001b[K");
                    }
                    if (interrupted.get() && !this.isWorkComplete()) {
                        outputStream.println("Interrupted by user (Ctrl-C)");
                    } else {
                        outputStream.println(this.getEnhancedProgressString(progressHistory, startTime) + " - Complete");
                    }
                }
                if (interrupted.get()) {
                    CompletableFuture future;
                    boolean completedNormally = false;
                    completedNormally = this instanceof CompletableFuture ? (future = (CompletableFuture)((Object)this)).isDone() && !future.isCancelled() && !future.isCompletedExceptionally() : this.isWorkComplete();
                    if (!completedNormally) {
                        throw new InterruptedException("Progress monitoring interrupted by user signal");
                    }
                }
                Void void_ = null;
                return void_;
            }
            catch (Exception e) {
                outputStream.println("\nError monitoring progress: " + e.getMessage());
                throw new RuntimeException(e);
            }
            finally {
                try {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        });
    }

    default public String getEnhancedProgressString(Deque<ProgressSample> progressHistory, long startTime) {
        String baseProgress = this.getProgressString();
        if (progressHistory.size() < 2) {
            return baseProgress;
        }
        ProgressSample oldest = progressHistory.peekFirst();
        ProgressSample newest = progressHistory.peekLast();
        long timeDiff = newest.timestamp - oldest.timestamp;
        double workDiff = newest.work - oldest.work;
        if (timeDiff <= 0L || workDiff <= 0.0) {
            return baseProgress;
        }
        double rate = workDiff * 1000.0 / (double)timeDiff;
        double remainingWork = this.getRemainingWork();
        String timeEstimate = "";
        if (rate > 0.0 && remainingWork > 0.0) {
            long estimatedSecondsRemaining = (long)(remainingWork / rate);
            timeEstimate = this.formatDuration(estimatedSecondsRemaining);
        }
        long elapsedMs = System.currentTimeMillis() - startTime;
        String elapsed = this.formatDuration(elapsedMs / 1000L);
        StringBuilder enhanced = new StringBuilder(baseProgress);
        enhanced.append(" [").append(String.format("%.1f/s", rate));
        double bytesPerUnit = this.getBytesPerUnit();
        if (bytesPerUnit > 1.0 && rate > 0.0) {
            double bytesPerSecond = rate * bytesPerUnit;
            double mbitsPerSecond = bytesPerSecond * 8.0 / 1048576.0;
            enhanced.append(String.format(", %.1f Mbit/s", mbitsPerSecond));
        }
        enhanced.append(", elapsed: ").append(elapsed);
        if (!timeEstimate.isEmpty()) {
            enhanced.append(", ETA: ").append(timeEstimate);
        }
        enhanced.append("]");
        return enhanced.toString();
    }

    default public String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            long remainingSeconds = seconds % 60L;
            return minutes + "m" + (String)(remainingSeconds > 0L ? " " + remainingSeconds + "s" : "");
        }
        long hours = seconds / 3600L;
        long remainingMinutes = seconds % 3600L / 60L;
        return hours + "h" + (String)(remainingMinutes > 0L ? " " + remainingMinutes + "m" : "");
    }

    default public String formatBytes(double bytes) {
        if (bytes < 1024.0) {
            return String.format("%.0f B", bytes);
        }
        if (bytes < 1048576.0) {
            return String.format("%.1f KB", bytes / 1024.0);
        }
        if (bytes < 1.073741824E9) {
            return String.format("%.1f MB", bytes / 1048576.0);
        }
        if (bytes < 1.099511627776E12) {
            return String.format("%.1f GB", bytes / 1.073741824E9);
        }
        return String.format("%.1f TB", bytes / 1.099511627776E12);
    }

    default public CompletableFuture<Void> monitorProgress(long intervalMs) {
        return this.monitorProgress(System.out, intervalMs);
    }

    public static class ProgressSnapshot {
        private final double currentWork;
        private final double totalWork;

        public ProgressSnapshot(double currentWork, double totalWork) {
            this.currentWork = currentWork;
            this.totalWork = totalWork;
        }

        public double currentWork() {
            return this.currentWork;
        }

        public double totalWork() {
            return this.totalWork;
        }

        public double getPercentage() {
            if (this.totalWork <= 0.0) {
                return 0.0;
            }
            return this.currentWork / this.totalWork * 100.0;
        }

        public double getFraction() {
            if (this.totalWork <= 0.0) {
                return 0.0;
            }
            return this.currentWork / this.totalWork;
        }

        public boolean isComplete() {
            return this.currentWork >= this.totalWork && this.totalWork > 0.0;
        }

        public double getRemainingWork() {
            return Math.max(0.0, this.totalWork - this.currentWork);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProgressSnapshot that = (ProgressSnapshot)obj;
            return Double.compare(that.currentWork, this.currentWork) == 0 && Double.compare(that.totalWork, this.totalWork) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.currentWork, this.totalWork);
        }

        public String toString() {
            return String.format("Progress[%.1f/%.1f (%.1f%%)]", this.currentWork, this.totalWork, this.getPercentage());
        }
    }

    public static class ProgressSample {
        private final double work;
        private final long timestamp;

        public ProgressSample(double work, long timestamp) {
            this.work = work;
            this.timestamp = timestamp;
        }

        public double work() {
            return this.work;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProgressSample that = (ProgressSample)obj;
            return Double.compare(that.work, this.work) == 0 && this.timestamp == that.timestamp;
        }

        public int hashCode() {
            return Objects.hash(this.work, this.timestamp);
        }
    }
}

