/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.fileio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermissions;

public class FilePaths {
    private FilePaths() {
    }

    public static Path relinkPath(Path fromPath, Path toPath) {
        try {
            Path parent = toPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Files.move(fromPath, toPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return toPath;
    }
}

