/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.fileio;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilesystemSpaceChecker {
    private static final double DEFAULT_MARGIN = 0.2;

    public static void checkSpaceAvailable(Path path, double sizeBytes) throws InsufficientSpaceException {
        FilesystemSpaceChecker.checkSpaceAvailable(path, sizeBytes, 0.2);
    }

    public static void checkSpaceAvailable(Path path, double sizeBytes, double marginPercent) throws InsufficientSpaceException {
        try {
            FileStore fileStore = FilesystemSpaceChecker.getFileStoreForPath(path);
            long usableSpace = fileStore.getUsableSpace();
            double requiredSpace = sizeBytes * (1.0 + marginPercent);
            if ((double)usableSpace < requiredSpace) {
                throw new InsufficientSpaceException(String.format("Insufficient disk space on filesystem %s for file %s. Required: %.2f GB (%.2f GB + %.0f%% margin), Available: %.2f GB", fileStore.name(), path.startsWith(fileStore.name()) ? path.toString().substring(fileStore.name().length()) : path.toString(), requiredSpace / 1.073741824E9, sizeBytes / 1.073741824E9, marginPercent * 100.0, (double)usableSpace / 1.073741824E9));
            }
        }
        catch (IOException e) {
            throw new InsufficientSpaceException("Failed to check disk space for path: " + String.valueOf(path), e);
        }
    }

    private static FileStore getFileStoreForPath(Path path) throws IOException {
        for (Path currentPath = path.toAbsolutePath(); currentPath != null; currentPath = currentPath.getParent()) {
            if (!Files.exists(currentPath, new LinkOption[0])) continue;
            return Files.getFileStore(currentPath);
        }
        return Files.getFileStore(path.getRoot());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class InsufficientSpaceException
    extends RuntimeException {
        public InsufficientSpaceException(String message) {
            super(message);
        }

        public InsufficientSpaceException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Builder {
        private final List<PathSizeRequirement> requirements = new ArrayList<PathSizeRequirement>();
        private double marginPercent = 0.2;

        public Builder withMargin(double marginPercent) {
            this.marginPercent = marginPercent;
            return this;
        }

        public Builder addPath(Path path, double sizeBytes) {
            this.requirements.add(new PathSizeRequirement(path, sizeBytes));
            return this;
        }

        public void checkAll() throws InsufficientSpaceException {
            try {
                FileStore fileStore;
                HashMap<FileStore, Double> fileStoreRequirements = new HashMap<FileStore, Double>();
                for (PathSizeRequirement pathSizeRequirement : this.requirements) {
                    fileStore = FilesystemSpaceChecker.getFileStoreForPath(pathSizeRequirement.path);
                    fileStoreRequirements.merge(fileStore, pathSizeRequirement.sizeBytes, Double::sum);
                }
                for (Map.Entry entry : fileStoreRequirements.entrySet()) {
                    double requiredSpace;
                    fileStore = (FileStore)entry.getKey();
                    double totalSizeBytes = (Double)entry.getValue();
                    long usableSpace = fileStore.getUsableSpace();
                    if (!((double)usableSpace < (requiredSpace = totalSizeBytes * (1.0 + this.marginPercent)))) continue;
                    String pathsInfo = this.requirements.stream().filter(req -> {
                        try {
                            return FilesystemSpaceChecker.getFileStoreForPath(req.path).equals(fileStore);
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }).map(req -> String.format("%s (%.2f GB)", req.path, req.sizeBytes / 1.073741824E9)).reduce((a, b) -> a + ", " + b).orElse("unknown paths");
                    throw new InsufficientSpaceException(String.format("Insufficient disk space on filesystem %s. Required: %.2f GB (%.2f GB + %.0f%% margin), Available: %.2f GB. Affected paths: %s", fileStore.name(), requiredSpace / 1.073741824E9, totalSizeBytes / 1.073741824E9, this.marginPercent * 100.0, (double)usableSpace / 1.073741824E9, pathsInfo));
                }
            }
            catch (IOException e) {
                throw new InsufficientSpaceException("Failed to check disk space for one or more paths", e);
            }
        }
    }

    private static class PathSizeRequirement {
        final Path path;
        final double sizeBytes;

        PathSizeRequirement(Path path, double sizeBytes) {
            this.path = path;
            this.sizeBytes = sizeBytes;
        }
    }
}

