/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.fileio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public class LongIndexedFloatVector
implements Comparable<LongIndexedFloatVector> {
    private final long index;
    private final float[] vector;
    public static Comparator<LongIndexedFloatVector> BY_VECTOR_SHAPE = new Comparator<LongIndexedFloatVector>(){

        @Override
        public int compare(LongIndexedFloatVector o1, LongIndexedFloatVector o2) {
            int range = Math.min(o1.vector.length, o2.vector.length);
            for (int i = 0; i < range; ++i) {
                int diff = Double.compare(o1.vector[i], o2.vector[i]);
                if (diff == 0) continue;
                return diff;
            }
            if (o1.vector.length > range) {
                return -1;
            }
            if (o2.vector.length > range) {
                return 1;
            }
            return 0;
        }
    };

    public LongIndexedFloatVector(long index, float[] vector) {
        this.index = index;
        this.vector = vector;
    }

    public long index() {
        return this.index;
    }

    public float[] vector() {
        return this.vector;
    }

    @Override
    public int compareTo(LongIndexedFloatVector o) {
        return Long.compare(this.index, o.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LongIndexedFloatVector that = (LongIndexedFloatVector)obj;
        return this.index == that.index && Arrays.equals(this.vector, that.vector);
    }

    public int hashCode() {
        return Objects.hash(this.index, Arrays.hashCode(this.vector));
    }

    public String toString() {
        return "query(" + this.index + "):float[" + this.vector.length + "] " + String.format("%+1.3f %+1.3f %+1.3f", Float.valueOf(this.vector[0]), Float.valueOf(this.vector[1]), Float.valueOf(this.vector[2])) + "...";
    }
}

