/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.fileio;

import io.nosqlbench.nbdatatools.api.fileio.BoundedVectorFileStream;
import io.nosqlbench.nbdatatools.api.fileio.VectorFileArray;
import io.nosqlbench.nbdatatools.api.iteration.ImmutableListIterator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class VectorFileArrayAdapter<T>
implements VectorFileArray<T> {
    private final BoundedVectorFileStream<T> stream;
    private final Class<T> elementType;

    public VectorFileArrayAdapter(BoundedVectorFileStream<?> stream, Class<T> elementType) {
        BoundedVectorFileStream<?> typedStream = stream;
        this.stream = typedStream;
        this.elementType = elementType;
    }

    @Override
    public void open(Path filePath) {
        this.stream.open(filePath);
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public T get(int index) {
        Iterator iterator = this.stream.iterator();
        for (int i = 0; i < index; ++i) {
            if (!iterator.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.stream.getSize());
            }
            iterator.next();
        }
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.stream.getSize());
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.stream.getSize();
    }

    @Override
    public int getSize() {
        return this.stream.getSize();
    }

    @Override
    public String getName() {
        return this.stream.getName();
    }

    @Override
    public boolean isEmpty() {
        return this.stream.getSize() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (Object item : this.stream) {
            if (!Objects.equals(item, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Object[] toArray() {
        ArrayList list = new ArrayList(this.stream.getSize());
        for (Object item : this.stream) {
            list.add(item);
        }
        return list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        ArrayList list = new ArrayList(this.stream.getSize());
        for (Object item : this.stream) {
            list.add(item);
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }

    @Override
    public int indexOf(Object o) {
        Iterator iterator = this.stream.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (Objects.equals(item, o)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Iterator iterator = this.stream.iterator();
        int index = 0;
        int lastIndex = -1;
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (Objects.equals(item, o)) {
                lastIndex = index;
            }
            ++index;
        }
        return lastIndex;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ImmutableListIterator(this, index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        int i;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.stream.getSize()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        ArrayList result = new ArrayList(toIndex - fromIndex);
        Iterator iterator = this.stream.iterator();
        for (i = 0; i < fromIndex; ++i) {
            if (!iterator.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.stream.getSize());
            }
            iterator.next();
        }
        for (i = fromIndex; i < toIndex; ++i) {
            if (!iterator.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.stream.getSize());
            }
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("This reader is immutable.");
    }
}

