/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.iteration;

import java.util.Iterator;

public class ConcatenatingIterable<O>
implements Iterable<O> {
    private final Iterable<Iterable<O>> sequence;

    public ConcatenatingIterable(Iterable<Iterable<O>> sequence) {
        this.sequence = sequence;
    }

    @Override
    public Iterator<O> iterator() {
        return new ConcatenatingIterator<O>(this.sequence);
    }

    public static class ConcatenatingIterator<O>
    implements Iterator<O> {
        private long inners;
        private long outers;
        private long totals;
        private Iterator<Iterable<O>> sequenceIterator;
        private Iterator<O> stageIterator;

        public ConcatenatingIterator(Iterable<Iterable<O>> sequence) {
            this.sequenceIterator = sequence.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.stageIterator == null || !this.stageIterator.hasNext()) {
                if (this.sequenceIterator.hasNext()) {
                    this.stageIterator = this.sequenceIterator.next().iterator();
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public O next() {
            return this.stageIterator.next();
        }
    }
}

