/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.iteration;

import java.util.Iterator;
import java.util.function.Function;

public class ConvertingIterable<I, O>
implements Iterable<O> {
    private final Iterable<I> inner;
    private final Function<I, O> converter;

    public ConvertingIterable(Iterable<I> inner, Function<I, O> converter) {
        this.inner = inner;
        this.converter = converter;
    }

    @Override
    public Iterator<O> iterator() {
        return new WrappedIterator<I, O>(this.inner.iterator(), this.converter);
    }

    public static class WrappedIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> innerIter;
        private final Function<I, O> converter;

        public WrappedIterator(Iterator<I> inner, Function<I, O> converter) {
            this.innerIter = inner;
            this.converter = converter;
        }

        @Override
        public boolean hasNext() {
            return this.innerIter.hasNext();
        }

        @Override
        public O next() {
            I next = this.innerIter.next();
            O converted = this.converter.apply(next);
            return converted;
        }
    }
}

