/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.iteration;

import io.nosqlbench.nbdatatools.api.types.Enumerated;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class EnumeratedIterable<T>
implements Iterable<T> {
    private final Iterable<T> inner;

    public EnumeratedIterable(Iterable<T> inner) {
        this.inner = inner;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new EnumeratedIterator<T>(this.inner.iterator());
    }

    public static <T> EnumeratedIterable<T> of(Iterable<T> inner) {
        if (inner instanceof EnumeratedIterable) {
            EnumeratedIterable ei = (EnumeratedIterable)inner;
            return ei;
        }
        return new EnumeratedIterable<T>(inner);
    }

    private class EnumeratedIterator<T>
    implements Iterator<T>,
    Enumerated<T> {
        private final Iterator<T> iterator;
        private long lastIndex = -1L;

        public EnumeratedIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            T next = this.iterator.next();
            ++this.lastIndex;
            return next;
        }

        @Override
        public long getLastIndex() {
            return this.lastIndex;
        }
    }
}

