/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.iteration;

import io.nosqlbench.nbdatatools.api.iteration.DiagToString;
import java.util.Iterator;
import java.util.function.Function;

public class FlatteningIterable<I, O>
implements Iterable<O> {
    private final Iterable<I> inner;
    private final Function<I, Iterable<O>> function;

    public FlatteningIterable(Iterable<I> inner) {
        this.function = i -> (Iterable)i;
        this.inner = inner;
    }

    public FlatteningIterable(Iterable<I> inner, Function<I, Iterable<O>> function) {
        this.inner = inner;
        this.function = function;
    }

    @Override
    public Iterator<O> iterator() {
        return new FlatteningIterator<I, O>(this.inner, this.function);
    }

    public static class FlatteningIterator<I, O>
    implements Iterator<O>,
    DiagToString {
        private long inners;
        private long outers;
        private long totals;
        private final Function<I, Iterable<O>> function;
        private final Iterator<I> inputIter;
        private Iterator<O> outputIter;

        public FlatteningIterator(Iterable<I> innerIterable, Function<I, Iterable<O>> function) {
            this.function = function;
            this.inputIter = innerIterable.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.outputIter == null || !this.outputIter.hasNext()) {
                if (this.inputIter.hasNext()) {
                    I nextInner = this.inputIter.next();
                    this.outputIter = this.function.apply(nextInner).iterator();
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public O next() {
            while (this.outputIter == null || !this.outputIter.hasNext() && this.inputIter.hasNext()) {
                I nextInner = this.inputIter.next();
                ++this.inners;
                this.outers = 0L;
                Iterable<O> outIter = this.function.apply(nextInner);
                this.outputIter = outIter.iterator();
            }
            ++this.outers;
            ++this.totals;
            return this.outputIter.next();
        }

        @Override
        public String toDiagString() {
            return "inners:" + this.inners + ", outers:" + this.outers + ", totals:" + this.totals;
        }
    }
}

