/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.iteration;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ImmutableListIterator<T>
implements ListIterator<T> {
    private final List<T> list;
    private int cursor;

    public ImmutableListIterator(List<T> list, int index) {
        this.list = Objects.requireNonNull(list, "List cannot be null");
        if (index < 0 || index > list.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + list.size());
        }
        this.cursor = index;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.list.get(this.cursor++);
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.list.get(--this.cursor);
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is immutable");
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException("This iterator is immutable");
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException("This iterator is immutable");
    }
}

