/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.services;

import io.nosqlbench.nbdatatools.api.fileio.BoundedVectorFileStream;
import io.nosqlbench.nbdatatools.api.fileio.VectorFileArray;
import io.nosqlbench.nbdatatools.api.fileio.VectorFileStreamStore;
import io.nosqlbench.nbdatatools.api.services.DataType;
import io.nosqlbench.nbdatatools.api.services.Encoding;
import io.nosqlbench.nbdatatools.api.services.FileExtension;
import io.nosqlbench.nbdatatools.api.services.FileType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class VectorFileIO {
    private static final ServiceLoader<VectorFileArray> serviceLoader = ServiceLoader.load(VectorFileArray.class);

    private VectorFileIO() {
    }

    public static <T> Optional<BoundedVectorFileStream<T>> streamIn(FileType encoding, Class<T> dataType, Path path) {
        String fileExtension = VectorFileIO.getFileExtension(path);
        List matchingProviders = VectorFileIO.streamProviders().stream().filter(provider -> VectorFileIO.matchesTypeAndEncoding(provider, encoding, dataType)).collect(Collectors.toList());
        List extensionMatches = matchingProviders.stream().filter(provider -> VectorFileIO.matchesFileExtension(provider, fileExtension)).collect(Collectors.toList());
        if (!extensionMatches.isEmpty()) {
            return extensionMatches.stream().findFirst().map(p -> (BoundedVectorFileStream)p.get()).map(reader -> {
                try {
                    reader.open(path);
                    return reader;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize bounded vector file stream:" + e.getMessage(), e);
                }
            });
        }
        if (!matchingProviders.isEmpty()) {
            System.err.println("Warning: No readers found for extension '" + fileExtension + "' that match the requested encoding and data type. Using best available match.");
            return matchingProviders.stream().findFirst().map(p -> (BoundedVectorFileStream)p.get()).map(reader -> {
                try {
                    reader.open(path);
                    return reader;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize bounded vector file stream:" + e.getMessage(), e);
                }
            });
        }
        return Optional.empty();
    }

    private static <T> Optional<BoundedVectorFileStream<T>> streamIn(String encodingName, Class<T> dataType, Path path) {
        try {
            FileType encoding = FileType.valueOf(encodingName.toLowerCase());
            return VectorFileIO.streamIn(encoding, dataType, path);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static boolean matchesEncoding(ServiceLoader.Provider<VectorFileArray> provider, FileType encoding) {
        Class<VectorFileArray> type = provider.type();
        Encoding encodingAnnotation = type.getAnnotation(Encoding.class);
        if (encodingAnnotation != null) {
            return encodingAnnotation.value() == encoding;
        }
        return false;
    }

    private static Stream<ServiceLoader.Provider<VectorFileArray>> providers() {
        return StreamSupport.stream(serviceLoader.stream().spliterator(), false);
    }

    private static boolean matchesDataType(ServiceLoader.Provider<VectorFileArray> provider, Class<?> dataType) {
        Class<VectorFileArray> type = provider.type();
        DataType dataTypeAnnotation = type.getAnnotation(DataType.class);
        return dataTypeAnnotation != null && dataTypeAnnotation.value().equals(dataType);
    }

    private static Optional<VectorFileArray> instantiateWithPath(ServiceLoader.Provider<VectorFileArray> provider, Path path) {
        Class<VectorFileArray> readerClass = provider.type();
        try {
            Constructor<VectorFileArray> constructor = readerClass.getConstructor(Path.class);
            return Optional.of(constructor.newInstance(path));
        }
        catch (NoSuchMethodException e) {
            try {
                VectorFileArray reader = provider.get();
                Method initMethod = readerClass.getMethod("init", Path.class);
                initMethod.invoke((Object)reader, path);
                return Optional.of(reader);
            }
            catch (Exception ex) {
                return Optional.empty();
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static List<ServiceLoader.Provider<BoundedVectorFileStream>> streamProviders() {
        ServiceLoader<BoundedVectorFileStream> serviceLoader = ServiceLoader.load(BoundedVectorFileStream.class);
        List<ServiceLoader.Provider<BoundedVectorFileStream>> providers = StreamSupport.stream(serviceLoader.stream().spliterator(), false).collect(Collectors.toList());
        return providers;
    }

    private static boolean matchesTypeAndEncoding(ServiceLoader.Provider<?> provider, FileType type, Class<?> dataType) {
        Class<?> providerClass = provider.type();
        DataType dataTypeAnnotation = providerClass.getAnnotation(DataType.class);
        Encoding encodingAnnotation = providerClass.getAnnotation(Encoding.class);
        return dataTypeAnnotation != null && encodingAnnotation != null && dataTypeAnnotation.value().equals(dataType) && encodingAnnotation.value() == type;
    }

    private static String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex > 0 ? fileName.substring(lastDotIndex) : "";
    }

    private static boolean matchesFileExtension(ServiceLoader.Provider<?> provider, String extension) {
        if (extension.isEmpty()) {
            return true;
        }
        Class<?> providerClass = provider.type();
        FileExtension fileExtensionAnnotation = providerClass.getAnnotation(FileExtension.class);
        if (fileExtensionAnnotation != null) {
            return Arrays.asList(fileExtensionAnnotation.value()).contains(extension.toLowerCase());
        }
        return false;
    }

    public static <T> VectorFileArray<T> randomAccess(FileType type, Class<T> aClass, Path outputFile) {
        String fileExtension = VectorFileIO.getFileExtension(outputFile);
        List matchingProviders = VectorFileIO.providers().filter(provider -> VectorFileIO.matchesTypeAndEncoding(provider, type, aClass)).collect(Collectors.toList());
        List extensionMatches = matchingProviders.stream().filter(provider -> VectorFileIO.matchesFileExtension(provider, fileExtension)).collect(Collectors.toList());
        if (!extensionMatches.isEmpty()) {
            return extensionMatches.stream().findFirst().map(provider -> {
                try {
                    VectorFileArray reader = (VectorFileArray)provider.get();
                    reader.open(outputFile);
                    return reader;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).orElseThrow(() -> new IllegalArgumentException("Failed to initialize vector file array for type " + aClass.getSimpleName() + " and encoding " + String.valueOf((Object)type)));
        }
        if (!matchingProviders.isEmpty()) {
            System.err.println("Warning: No readers found for extension '" + fileExtension + "' that match the requested encoding and data type. Using best available match.");
            return matchingProviders.stream().findFirst().map(provider -> {
                try {
                    VectorFileArray reader = (VectorFileArray)provider.get();
                    reader.open(outputFile);
                    return reader;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).orElseThrow(() -> new IllegalArgumentException("Failed to initialize vector file array for type " + aClass.getSimpleName() + " and encoding " + String.valueOf((Object)type)));
        }
        throw new IllegalArgumentException("No vector file array implementation found for type " + aClass.getSimpleName() + " and encoding " + String.valueOf((Object)type));
    }

    private static Stream<ServiceLoader.Provider<VectorFileStreamStore>> storeProviders() {
        ServiceLoader<VectorFileStreamStore> serviceLoader = ServiceLoader.load(VectorFileStreamStore.class);
        return StreamSupport.stream(serviceLoader.stream().spliterator(), false);
    }

    public static <T> Optional<VectorFileStreamStore<T>> streamOut(FileType type, Class<T> aClass, Path outputFile) {
        String fileExtension = VectorFileIO.getFileExtension(outputFile);
        List matchingProviders = VectorFileIO.storeProviders().filter(provider -> VectorFileIO.matchesTypeAndEncoding(provider, type, aClass)).collect(Collectors.toList());
        List extensionMatches = matchingProviders.stream().filter(provider -> VectorFileIO.matchesFileExtension(provider, fileExtension)).collect(Collectors.toList());
        if (!extensionMatches.isEmpty()) {
            return extensionMatches.stream().findFirst().map(provider -> {
                try {
                    VectorFileStreamStore store = (VectorFileStreamStore)provider.get();
                    store.open(outputFile);
                    VectorFileStreamStore typedStore = store;
                    return typedStore;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize vector file store", e);
                }
            });
        }
        if (!matchingProviders.isEmpty()) {
            System.err.println("Warning: No writers found for extension '" + fileExtension + "' that match the requested encoding and data type. Using best available match, but the file extension may be incorrect.");
            return matchingProviders.stream().findFirst().map(provider -> {
                try {
                    VectorFileStreamStore store = (VectorFileStreamStore)provider.get();
                    store.open(outputFile);
                    VectorFileStreamStore typedStore = store;
                    return typedStore;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to initialize vector file store", e);
                }
            });
        }
        return Optional.empty();
    }
}

