/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.transport;

import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteBufferStreamingResult
implements StreamingFetchResult {
    private final ByteBuffer data;
    private final long offset;
    private final long requestedLength;
    private final String source;
    private final ByteBufferChannel channel;
    private volatile boolean closed = false;

    public ByteBufferStreamingResult(ByteBuffer data, long offset, long requestedLength, String source) {
        this.data = data;
        this.offset = offset;
        this.requestedLength = requestedLength;
        this.source = source;
        this.channel = new ByteBufferChannel(data);
    }

    @Override
    public ReadableByteChannel getDataChannel() {
        if (this.closed) {
            throw new IllegalStateException("StreamingFetchResult has been closed");
        }
        return this.channel;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getRequestedLength() {
        return this.requestedLength;
    }

    @Override
    public long getActualLength() {
        return this.data != null ? (long)this.data.remaining() : 0L;
    }

    @Override
    public boolean isSuccessful() {
        return this.data != null && !this.closed;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.channel.close();
    }

    private static class ByteBufferChannel
    implements ReadableByteChannel {
        private final ByteBuffer source;
        private volatile boolean open = true;

        ByteBufferChannel(ByteBuffer source) {
            this.source = source;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (!this.open) {
                throw new IOException("Channel is closed");
            }
            if (!this.source.hasRemaining()) {
                return -1;
            }
            int bytesToRead = Math.min(dst.remaining(), this.source.remaining());
            if (bytesToRead == 0) {
                return 0;
            }
            int oldLimit = this.source.limit();
            this.source.limit(this.source.position() + bytesToRead);
            dst.put(this.source);
            this.source.limit(oldLimit);
            return bytesToRead;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() throws IOException {
            this.open = false;
        }
    }
}

