/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.transport;

import io.nosqlbench.nbdatatools.api.transport.ByteBufferStreamingResult;
import io.nosqlbench.nbdatatools.api.transport.FetchResult;
import io.nosqlbench.nbdatatools.api.transport.StreamingFetchResult;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public interface ChunkedTransportClient
extends AutoCloseable {
    public CompletableFuture<? extends FetchResult<?>> fetchRange(long var1, long var3) throws IOException;

    default public CompletableFuture<StreamingFetchResult> fetchRangeStreaming(long offset, long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Default ByteBuffer-based implementation cannot handle individual chunks larger than 2GB (" + length + " bytes requested). Use a streaming-optimized transport implementation or split the request into smaller chunks."));
        }
        return this.fetchRange(offset, length).thenApply(result -> new ByteBufferStreamingResult(result.getData(), offset, length, this.getSource()));
    }

    public CompletableFuture<Long> getSize() throws IOException;

    public boolean supportsRangeRequests();

    public String getSource();

    @Override
    public void close() throws IOException;
}

