/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.transport;

import io.nosqlbench.nbdatatools.api.services.TransportScheme;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportClient;
import io.nosqlbench.nbdatatools.api.transport.ChunkedTransportProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ServiceLoader;

public class ChunkedTransportIO {
    public static ChunkedTransportClient create(String url) throws IOException {
        URL urlObj;
        String scheme;
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        url = url.trim();
        try {
            URI uri = new URI(url);
            scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "file";
            }
        }
        catch (URISyntaxException e) {
            scheme = "file";
        }
        try {
            if (scheme == null || "file".equalsIgnoreCase(scheme)) {
                if (url.startsWith("file://")) {
                    urlObj = new URL(url);
                } else {
                    Path path = Paths.get(url, new String[0]).toAbsolutePath();
                    urlObj = path.toUri().toURL();
                }
            } else {
                urlObj = new URL(url);
            }
        }
        catch (MalformedURLException e) {
            throw new IOException("Invalid URL: " + url, e);
        }
        ServiceLoader<ChunkedTransportProvider> loader = ServiceLoader.load(ChunkedTransportProvider.class);
        for (ChunkedTransportProvider provider : loader) {
            TransportScheme annotation = provider.getClass().getAnnotation(TransportScheme.class);
            if (annotation == null) continue;
            String[] supportedSchemes = annotation.value();
            String urlScheme = urlObj.getProtocol();
            for (String supportedScheme : supportedSchemes) {
                if (!supportedScheme.equalsIgnoreCase(urlScheme)) continue;
                try {
                    return provider.getClient(urlObj);
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("No transport provider found for URL: " + url);
    }

    public static ChunkedTransportClient create(URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        return ChunkedTransportIO.create(uri.toString());
    }

    public static ChunkedTransportClient create(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return ChunkedTransportIO.create(path.toUri().toString());
    }
}

