/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.types.bitimage;

import java.util.BitSet;

public class BitImage {
    private BitSet ones = new BitSet();
    private BitSet zeros = new BitSet();

    public BitImage(int length) {
        this.zeros.set(length - 1);
    }

    public BitImage(BitSet zeros, BitSet ones) {
        this.ones = ones;
        this.zeros = zeros;
    }

    public void set(int idx) {
        this.ones.set(idx);
    }

    public void setZero(int idx) {
        this.zeros.set(idx);
    }

    public int length() {
        return Math.max(this.ones.length(), this.zeros.length());
    }

    public BitSet mask() {
        BitSet mask = new BitSet();
        mask.or(this.ones);
        mask.or(this.zeros);
        return mask;
    }

    public byte[] toByteArray() {
        byte[] oneBits = this.ones.toByteArray();
        byte[] zeroBits = this.zeros.toByteArray();
        byte[] allBits = new byte[Math.max(oneBits.length, zeroBits.length)];
        System.arraycopy(oneBits, 0, allBits, 0, oneBits.length);
        return allBits;
    }

    public BitSet getOnes() {
        return this.ones;
    }

    public BitSet getZeros() {
        return this.zeros;
    }

    public boolean get(int idx) {
        return this.ones.get(idx);
    }
}

