/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.types.bitimage;

import io.nosqlbench.nbdatatools.api.types.bitimage.BitImage;
import java.util.BitSet;

public class Glyphs {
    public static String table = "\u2800\u2801\u2802\u2803\u2804\u2805\u2806\u2807\u2840\u2841\u2842\u2843\u2844\u2845\u2846\u2847\n\u2808\u2809\u280a\u280b\u280c\u280d\u280e\u280f\u2848\u2849\u284a\u284b\u284c\u284d\u284e\u284f\n\u2810\u2811\u2812\u2813\u2814\u2815\u2816\u2817\u2850\u2851\u2852\u2853\u2854\u2855\u2856\u2857\n\u2818\u2819\u281a\u281b\u281c\u281d\u281e\u281f\u2858\u2859\u285a\u285b\u285c\u285d\u285e\u285f\n\u2820\u2821\u2822\u2823\u2824\u2825\u2826\u2827\u2860\u2861\u2862\u2863\u2864\u2865\u2866\u2867\n\u2828\u2829\u282a\u282b\u282c\u282d\u282e\u282f\u2868\u2869\u286a\u286b\u286c\u286d\u286e\u286f\n\u2830\u2831\u2832\u2833\u2834\u2835\u2836\u2837\u2870\u2871\u2872\u2873\u2874\u2875\u2876\u2877\n\u2838\u2839\u283a\u283b\u283c\u283d\u283e\u283f\u2878\u2879\u287a\u287b\u287c\u287d\u287e\u287f\n\u2880\u2881\u2882\u2883\u2884\u2885\u2886\u2887\u28c0\u28c1\u28c2\u28c3\u28c4\u28c5\u28c6\u28c7\n\u2888\u2889\u288a\u288b\u288c\u288d\u288e\u288f\u28c8\u28c9\u28ca\u28cb\u28cc\u28cd\u28ce\u28cf\n\u2890\u2891\u2892\u2893\u2894\u2895\u2896\u2897\u28d0\u28d1\u28d2\u28d3\u28d4\u28d5\u28d6\u28d7\n\u2898\u2899\u289a\u289b\u289c\u289d\u289e\u289f\u28d8\u28d9\u28da\u28db\u28dc\u28dd\u28de\u28df\n\u28a0\u28a1\u28a2\u28a3\u28a4\u28a5\u28a6\u28a7\u28e0\u28e1\u28e2\u28e3\u28e4\u28e5\u28e6\u28e7\n\u28a8\u28a9\u28aa\u28ab\u28ac\u28ad\u28ae\u28af\u28e8\u28e9\u28ea\u28eb\u28ec\u28ed\u28ee\u28ef\n\u28b0\u28b1\u28b2\u28b3\u28b4\u28b5\u28b6\u28b7\u28f0\u28f1\u28f2\u28f3\u28f4\u28f5\u28f6\u28f7\n\u28b8\u28b9\u28ba\u28bb\u28bc\u28bd\u28be\u28bf\u28f8\u28f9\u28fa\u28fb\u28fc\u28fd\u28fe\u28ff\n".replaceAll("\n", "");
    public static char[] chars = table.toCharArray();
    public static int[] lookupOffset = Glyphs.invertWithBase(chars);
    public static int[] maskByShift = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    static final int BRAILLE_BASE = 10240;

    public static String braille(BitSet bits) {
        byte[] bary = bits.toByteArray();
        return Glyphs.braille(bary);
    }

    public static String braille(BitImage bits) {
        byte[] bary = bits.toByteArray();
        return Glyphs.braille(bary);
    }

    public static String braille(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Glyphs.braille(b));
        }
        return sb.toString();
    }

    public static char braille(int v) {
        return Glyphs.braille((byte)v);
    }

    public static char braille(byte b) {
        int bits = Byte.toUnsignedInt(b);
        int image = bits & 7 | (bits & 8) << 3 | (bits & 0x70) >> 1 | bits & 0x80;
        char braille = (char)(10240 + image);
        return braille;
    }

    public static char andMask(char c, int mask) {
        if (c == ' ') {
            c = (char)10240;
        }
        int order = lookupOffset[c - 10240];
        int offset = mask & order;
        return chars[offset];
    }

    public static char orMask(char c, int mask) {
        if (c == ' ') {
            c = (char)10240;
        }
        int order = lookupOffset[c - 10240];
        int offset = mask | order;
        return chars[offset];
    }

    public static char andNotMask(char c, int mask) {
        if (c == ' ') {
            c = (char)10240;
        }
        int order = lookupOffset[c - 10240];
        int offset = ~mask & order;
        return chars[offset];
    }

    public static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i % 4 == 0) {
                sb.append(" ");
            } else {
                sb.append(".");
            }
            sb.append(String.format("%02X", bytes[i]));
        }
        return sb.toString();
    }

    private static int[] invertWithBase(char[] perm) {
        char base = perm[0];
        int[] inverse = new int[perm.length];
        int i = 0;
        while (i < perm.length) {
            char c = perm[i];
            int v = c - base;
            inverse[v] = i++;
        }
        return inverse;
    }
}

