/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nbdatatools.api.types.terminal;

import io.nosqlbench.nbdatatools.api.types.terminal.ColorDepth;
import java.util.Map;
import java.util.function.Function;

public class TerminalColorSupport {
    private static final Function<String, String> DEFAULT_ENV_ACCESSOR = System::getenv;

    public static ColorDepth detectColorDepth() {
        return TerminalColorSupport.detectColorDepth(DEFAULT_ENV_ACCESSOR);
    }

    public static ColorDepth detectColorDepth(Map<String, String> envVars) {
        return TerminalColorSupport.detectColorDepth(envVars::get);
    }

    public static ColorDepth detectColorDepth(Function<String, String> envAccessor) {
        String colorTerm = envAccessor.apply("COLORTERM");
        if (colorTerm != null) {
            if ((colorTerm = colorTerm.toLowerCase()).contains("truecolor") || colorTerm.contains("24bit")) {
                return ColorDepth.ANSI24BITCOLOR;
            }
            if (colorTerm.contains("256color")) {
                return ColorDepth.ANSI256COLOR;
            }
            return ColorDepth.ANSI8COLOR;
        }
        String term = envAccessor.apply("TERM");
        if (term != null) {
            if ((term = term.toLowerCase()).contains("256color")) {
                return ColorDepth.ANSI256COLOR;
            }
            if (term.contains("color")) {
                return ColorDepth.ANSI8COLOR;
            }
        }
        return ColorDepth.NOCOLOR;
    }

    public static ColorDepth getCurrentColorDepth() {
        return TerminalColorSupport.detectColorDepth();
    }
}

