/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.deployment;

import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.ExecutionModel;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class FeatureMethodBuildItem
extends MultiBuildItem {
    private final Feature feature;
    private final ExecutionModel executionModel;
    private final BeanInfo bean;
    private final InvokerInfo invoker;
    private final MethodInfo method;
    private final String name;
    private final String title;
    private final String description;
    private final String uri;
    private final String mimeType;
    private final int size;
    private final Content.Annotations resourceAnnotations;
    private final ToolManager.ToolAnnotations toolAnnotations;
    private final boolean structuredContent;
    private final Type outputSchemaFrom;
    private final Type outputSchemaGenerator;
    private final Type inputSchemaGenerator;
    private final List<DotName> inputGuardrails;
    private final List<DotName> outputGuardrails;
    private final DotName iconsProvider;
    private final String server;
    private final Map<String, String> metadata;

    FeatureMethodBuildItem(BeanInfo bean, MethodInfo method, InvokerInfo invoker, String name, String title, String description, String uri, String mimeType, int size, Feature feature, ToolManager.ToolAnnotations toolAnnotations, String server, boolean structuredContent, Type outputSchemaFrom, Type outputSchemaGenerator, Type inputSchemaGenerator, Content.Annotations resourceAnnotations, Map<String, String> metadata, List<DotName> inputGuardrails, List<DotName> outputGuardrails, ExecutionModel executionModel, DotName iconsProvider) {
        this.bean = Objects.requireNonNull(bean);
        this.method = Objects.requireNonNull(method);
        this.invoker = Objects.requireNonNull(invoker);
        this.feature = Objects.requireNonNull(feature);
        this.name = Objects.requireNonNull(name);
        this.title = title;
        this.description = description;
        this.uri = feature.requiresUri() ? Objects.requireNonNull(uri) : null;
        this.mimeType = mimeType;
        this.size = size;
        this.toolAnnotations = toolAnnotations;
        this.server = server;
        this.structuredContent = structuredContent;
        this.outputSchemaFrom = outputSchemaFrom;
        this.outputSchemaGenerator = outputSchemaGenerator;
        this.inputSchemaGenerator = inputSchemaGenerator;
        this.resourceAnnotations = resourceAnnotations;
        this.metadata = Objects.requireNonNull(metadata);
        this.inputGuardrails = inputGuardrails;
        this.outputGuardrails = outputGuardrails;
        this.executionModel = executionModel;
        this.iconsProvider = iconsProvider;
    }

    BeanInfo getBean() {
        return this.bean;
    }

    MethodInfo getMethod() {
        return this.method;
    }

    InvokerInfo getInvoker() {
        return this.invoker;
    }

    String getName() {
        return this.name;
    }

    String getTitle() {
        return this.title;
    }

    String getDescription() {
        return this.description;
    }

    String getUri() {
        return this.uri;
    }

    String getMimeType() {
        return this.mimeType;
    }

    int getSize() {
        return this.size;
    }

    Feature getFeature() {
        return this.feature;
    }

    ToolManager.ToolAnnotations getToolAnnotations() {
        return this.toolAnnotations;
    }

    String getServer() {
        return this.server;
    }

    boolean isStructuredContent() {
        return this.structuredContent;
    }

    Type getOutputSchemaFrom() {
        return this.outputSchemaFrom;
    }

    Type getOutputSchemaGenerator() {
        return this.outputSchemaGenerator;
    }

    Type getInputSchemaGenerator() {
        return this.inputSchemaGenerator;
    }

    Content.Annotations getResourceAnnotations() {
        return this.resourceAnnotations;
    }

    Map<String, String> getMetadata() {
        return this.metadata;
    }

    List<DotName> getInputGuardrails() {
        return this.inputGuardrails;
    }

    List<DotName> getOutputGuardrails() {
        return this.outputGuardrails;
    }

    ExecutionModel getExecutionModel() {
        return this.executionModel;
    }

    DotName getIconsProvider() {
        return this.iconsProvider;
    }

    boolean isTool() {
        return this.feature == Feature.TOOL;
    }

    boolean isPrompt() {
        return this.feature == Feature.PROMPT;
    }

    boolean isPromptComplete() {
        return this.feature == Feature.PROMPT_COMPLETE;
    }

    boolean isResource() {
        return this.feature == Feature.RESOURCE;
    }

    boolean isResourceTemplate() {
        return this.feature == Feature.RESOURCE_TEMPLATE;
    }

    boolean isResourceTemplateComplete() {
        return this.feature == Feature.RESOURCE_TEMPLATE_COMPLETE;
    }

    boolean isNotification() {
        return this.feature == Feature.NOTIFICATION;
    }

    public String toString() {
        return "FeatureMethodBuildItem [name=" + this.name + ", method=" + String.valueOf(this.method.declaringClass()) + "#" + this.method.name() + "(), feature=" + String.valueOf(this.feature) + "]";
    }
}

